/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentProviderElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParentAwareTokenSet {
    @NotNull
    private final TokenSet myTokenSet;

    private ParentAwareTokenSet(@NotNull TokenSet set) {
        this.myTokenSet = set;
    }

    @Contract(value="null -> false")
    public boolean contains(@Nullable IElementType iElementType) {
        if (iElementType == null) {
            return false;
        }
        return ParentProviderElementType.containsWithSourceParent(iElementType, this.myTokenSet);
    }

    @NotNull
    public static ParentAwareTokenSet create(@NotNull TokenSet set) {
        return new ParentAwareTokenSet(set);
    }

    @NotNull
    public static ParentAwareTokenSet create(@NotNull Set<IElementType> set) {
        return new ParentAwareTokenSet(TokenSet.create(set.toArray(IElementType.EMPTY_ARRAY)));
    }

    @NotNull
    public static ParentAwareTokenSet orSet(ParentAwareTokenSet ... sets) {
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])Arrays.stream(sets).map(t -> t.myTokenSet).toArray(TokenSet[]::new));
        return new ParentAwareTokenSet(tokenSet);
    }

    @NotNull
    public static ParentAwareTokenSet create(IElementType ... set) {
        TokenSet tokenSet = TokenSet.create(set);
        return new ParentAwareTokenSet(tokenSet);
    }
}

