/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.psi.impl.source.codeStyle.LexemeIterator;
import com.intellij.psi.impl.source.codeStyle.LexemeIteratorImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SemanticEditorPosition {
    private final LexemeIterator myIterator;
    private final CharSequence myChars;
    private final Function<? super IElementType, ? extends SyntaxElement> myTypeMapper;
    private final Function<? super Integer, ? extends LexemeIterator> myCreateLexemeIteratorAtOffset;

    private SemanticEditorPosition(int offset, @NotNull CharSequence chars, @NotNull Function<? super Integer, ? extends LexemeIterator> createLexemeIteratorAtOffset, @NotNull Function<? super IElementType, ? extends SyntaxElement> typeMapper) {
        this.myCreateLexemeIteratorAtOffset = createLexemeIteratorAtOffset;
        this.myChars = chars;
        this.myIterator = createLexemeIteratorAtOffset.apply((Integer)offset);
        this.myTypeMapper = typeMapper;
    }

    public void moveBeforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptional(@NotNull SyntaxElement syntaxElement) {
        return this.copyAnd(position -> position.moveBeforeOptional(syntaxElement));
    }

    public void moveBeforeOptionalMix(SyntaxElement ... elements) {
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptionalMix(SyntaxElement ... elements) {
        return this.copyAnd(position -> position.moveBeforeOptionalMix(elements));
    }

    public void moveAfterOptionalMix(SyntaxElement ... elements) {
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptionalMix(SyntaxElement ... elements) {
        return this.copyAnd(position -> position.moveAfterOptionalMix(elements));
    }

    public boolean isAtMultiline() {
        if (!this.myIterator.atEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
        }
        return false;
    }

    public boolean hasLineBreaksAfter(int offset) {
        int offsetAfter;
        if (!this.myIterator.atEnd() && offset >= 0 && (offsetAfter = offset + 1) < this.myIterator.getEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)offsetAfter, (int)this.myIterator.getEnd());
        }
        return false;
    }

    public boolean isAtMultiline(SyntaxElement ... elements) {
        return this.isAtAnyOf(elements) && CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
    }

    public void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition before() {
        return this.copyAnd(SemanticEditorPosition::moveBefore);
    }

    public void moveAfterOptional(@NotNull SyntaxElement syntaxElement) {
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptional(@NotNull SyntaxElement syntaxElement) {
        return this.copyAnd(position -> position.moveAfterOptional(syntaxElement));
    }

    public void moveAfter() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition after() {
        return this.copyAnd(SemanticEditorPosition::moveAfter);
    }

    public void moveBeforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        this.skipParentheses(false, leftParenthesis, rightParenthesis);
    }

    public void moveAfterParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        this.skipParentheses(true, leftParenthesis, rightParenthesis);
    }

    protected void skipParentheses(boolean forward, @NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        int parenLevel = 0;
        while (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            if (forward) {
                this.myIterator.advance();
            } else {
                this.myIterator.retreat();
            }
            if (rightParenthesis.equals(currElement)) {
                ++parenLevel;
                continue;
            }
            if (!leftParenthesis.equals(currElement) || --parenLevel >= 1) continue;
            break;
        }
    }

    public SemanticEditorPosition beforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        return this.copyAnd(position -> position.moveBeforeParentheses(leftParenthesis, rightParenthesis));
    }

    public void moveToLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        this.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(leftParenthesis, rightParenthesis, any -> false);
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        return this.copyAnd(position -> position.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis));
    }

    public void moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Predicate<? super SemanticEditorPosition> terminationCondition) {
        while (!this.myIterator.atEnd() && !terminationCondition.test(this)) {
            if (rightParenthesis.equals(this.map(this.myIterator.getTokenType()))) {
                this.moveBeforeParentheses(leftParenthesis, rightParenthesis);
                continue;
            }
            if (leftParenthesis.equals(this.map(this.myIterator.getTokenType()))) break;
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Predicate<? super SemanticEditorPosition> terminationCondition) {
        return this.copyAnd(position -> position.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(leftParenthesis, rightParenthesis, terminationCondition));
    }

    public boolean isAfterOnSameLine(SyntaxElement ... syntaxElements) {
        return this.elementAfterOnSameLine(syntaxElements) != null;
    }

    @Nullable
    public SyntaxElement elementAfterOnSameLine(SyntaxElement ... syntaxElements) {
        this.myIterator.retreat();
        while (!this.myIterator.atEnd() && !this.isAtMultiline()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return element;
            }
            this.myIterator.retreat();
        }
        return null;
    }

    public boolean isAt(@NotNull SyntaxElement syntaxElement) {
        return !this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()));
    }

    public boolean isAt(@NotNull IElementType elementType) {
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    public boolean isAtEnd() {
        return this.myIterator.atEnd();
    }

    public int getStartOffset() {
        return this.myIterator.getStart();
    }

    public boolean isAtAnyOf(SyntaxElement ... syntaxElements) {
        if (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    public CharSequence getChars() {
        return this.myChars;
    }

    public int findStartOf(@NotNull SyntaxElement element) {
        while (!this.myIterator.atEnd()) {
            if (element.equals(this.map(this.myIterator.getTokenType()))) {
                return this.myIterator.getStart();
            }
            this.myIterator.retreat();
        }
        return -1;
    }

    public boolean hasEmptyLineAfter(int offset) {
        for (int i = offset + 1; i < this.myIterator.getEnd(); ++i) {
            if (this.myChars.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    @Nullable
    public SyntaxElement getCurrElement() {
        return !this.myIterator.atEnd() ? this.map(this.myIterator.getTokenType()) : null;
    }

    public boolean matchesRule(@NotNull Rule rule) {
        return rule.check(this);
    }

    public SyntaxElement map(@NotNull IElementType elementType) {
        return this.myTypeMapper.apply(elementType);
    }

    public String toString() {
        return this.myIterator.atEnd() ? "atEnd" : this.myIterator.getTokenType().toString() + "=>" + String.valueOf(this.getChars().subSequence(this.getStartOffset(), Integer.min(this.getStartOffset() + 255, this.getChars().length())));
    }

    public SemanticEditorPosition copy() {
        return SemanticEditorPosition.createEditorPosition(this.isAtEnd() ? -1 : this.myIterator.getStart(), this.myChars, offset -> !this.isAtEnd() ? this.myCreateLexemeIteratorAtOffset.apply((Integer)offset) : new LexemeIteratorImpl.Wrapper(this.myIterator), this.myTypeMapper);
    }

    public SemanticEditorPosition copyAnd(@NotNull Consumer<? super SemanticEditorPosition> modifier) {
        SemanticEditorPosition position = this.copy();
        modifier.accept(position);
        return position;
    }

    public Language getLanguage() {
        return !this.myIterator.atEnd() ? this.myIterator.getTokenType().getLanguage() : null;
    }

    public boolean isAtLanguage(@Nullable Language language) {
        return !this.myIterator.atEnd() && (language == Language.ANY || this.myIterator.getTokenType().getLanguage().is(language));
    }

    @NotNull
    public static SemanticEditorPosition createEditorPosition(int offset, CharSequence chars, @NotNull Function<Integer, ? extends LexemeIterator> createLexemeIteratorAtOffset, @NotNull Function<? super IElementType, ? extends SyntaxElement> typeMapper) {
        return new SemanticEditorPosition(offset, chars, createLexemeIteratorAtOffset, typeMapper);
    }

    public static interface SyntaxElement {
    }

    public static interface Rule {
        public boolean check(SemanticEditorPosition var1);
    }
}

