/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.builder.MarkerOptionalData;
import com.intellij.psi.builder.MarkerPool;
import java.util.Arrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.mutable.primitive.MutableIntList;
import kala.function.IntHasher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class MarkerProduction {
    private final MutableIntList delegate = MutableIntArrayList.create((int)256);
    private static final Logger LOG = Logger.getInstance(MarkerProduction.class);
    private static final int LINEAR_SEARCH_LIMIT = 20;
    private final MarkerPool myPool;
    private final MarkerOptionalData myOptionalData;

    MarkerProduction(MarkerPool pool, MarkerOptionalData optionalData) {
        this.myPool = pool;
        this.myOptionalData = optionalData;
    }

    void addBefore(FleetPsiBuilder.ProductionMarker marker, FleetPsiBuilder.ProductionMarker anchor) {
        this.insert(this.indexOf(anchor), marker.markerId);
    }

    public int getInt(int index) {
        return this.get(index);
    }

    public int removeInt(int index) {
        return this.removeAt(index);
    }

    private int indexOf(FleetPsiBuilder.ProductionMarker marker) {
        int idx = this.findLinearly(marker.markerId);
        if (idx < 0) {
            for (int i = this.findMarkerAtLexeme(marker.getLexemeIndex(false)); i < this.size(); ++i) {
                if (this.getInt(i) != marker.markerId) continue;
                return i;
            }
        }
        if (idx < 0) {
            LOG.error("Dropped or rolled-back marker");
        }
        return idx;
    }

    private int findLinearly(int markerId) {
        int low = Math.max(0, this.size() - 20);
        for (int i = this.size() - 1; i >= low; --i) {
            if (this.getInt(i) != markerId) continue;
            return i;
        }
        return -1;
    }

    private int findMarkerAtLexeme(int lexemeIndex) {
        int i = MarkerProduction.binarySearch(0, this.size() - 20, mid -> Integer.compare(this.getLexemeIndexAt(mid), lexemeIndex));
        return i < 0 ? -1 : this.findSameLexemeGroupStart(lexemeIndex, i);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.delegate.isNotEmpty();
    }

    public int get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.delegate.get(index);
    }

    public void append(int value) {
        this.delegate.append(value);
    }

    public void prepend(int value) {
        this.delegate.prepend(value);
    }

    public void insert(int index, int value) {
        this.delegate.insert(index, value);
    }

    public int removeAt(int index) {
        return this.delegate.removeAt(index);
    }

    public void clear() {
        this.delegate.clear();
    }

    public void set(int index, int newValue) {
        this.delegate.set(index, newValue);
    }

    @NotNull
    public IntIterator iterator() {
        return this.delegate.iterator();
    }

    public int lastIndexOf(int value) {
        for (int i = this.delegate.size() - 1; i > 0; --i) {
            if (this.delegate.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    private static int binarySearch(int fromIndex, int toIndex, @NotNull IntHasher indexComparator) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = indexComparator.hash(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int findSameLexemeGroupStart(int lexemeIndex, int prodIndex) {
        while (prodIndex > 0 && this.getLexemeIndexAt(prodIndex - 1) == lexemeIndex) {
            --prodIndex;
        }
        return prodIndex;
    }

    void addMarker(FleetPsiBuilder.ProductionMarker marker) {
        this.append(marker.markerId);
    }

    void rollbackTo(FleetPsiBuilder.ProductionMarker marker) {
        int idx = this.indexOf(marker);
        for (int i = this.size() - 1; i >= idx; --i) {
            int markerId = this.getInt(i);
            if (markerId > 0) {
                this.myPool.freeMarker((FleetPsiBuilder.ProductionMarker)this.myPool.get(markerId));
            }
            this.removeInt(i);
        }
    }

    boolean hasErrorsAfter(@NotNull FleetPsiBuilder.StartMarker marker) {
        for (int i = this.indexOf(marker) + 1; i < this.size(); ++i) {
            FleetPsiBuilder.ProductionMarker m = this.getStartMarkerAt(i);
            if (m == null || !this.hasError(m)) continue;
            return true;
        }
        return false;
    }

    private boolean hasError(FleetPsiBuilder.ProductionMarker marker) {
        return marker instanceof FleetPsiBuilder.ErrorItem || this.myOptionalData.getDoneError(marker.markerId) != null;
    }

    void dropMarker(@NotNull FleetPsiBuilder.StartMarker marker) {
        if (marker.isDone()) {
            this.removeInt(this.lastIndexOf(-marker.markerId));
        }
        this.removeInt(this.indexOf(marker));
        this.myPool.freeMarker(marker);
    }

    void addDone(FleetPsiBuilder.StartMarker marker, @Nullable FleetPsiBuilder.ProductionMarker anchorBefore) {
        this.insert(anchorBefore == null ? this.size() : this.indexOf(anchorBefore), -marker.markerId);
    }

    @Nullable
    FleetPsiBuilder.ProductionMarker getMarkerAt(int index) {
        int id = this.getInt(index);
        return (FleetPsiBuilder.ProductionMarker)this.myPool.get(id > 0 ? id : -id);
    }

    @Nullable
    FleetPsiBuilder.ProductionMarker getStartMarkerAt(int index) {
        int id = this.getInt(index);
        return id > 0 ? (FleetPsiBuilder.ProductionMarker)this.myPool.get(id) : null;
    }

    @Nullable
    FleetPsiBuilder.StartMarker getDoneMarkerAt(int index) {
        int id = this.getInt(index);
        return id < 0 ? (FleetPsiBuilder.StartMarker)this.myPool.get(-id) : null;
    }

    int getLexemeIndexAt(int productionIndex) {
        int id = this.getInt(productionIndex);
        return ((FleetPsiBuilder.ProductionMarker)this.myPool.get(Math.abs(id))).getLexemeIndex(id < 0);
    }

    void confineMarkersToMaxLexeme(int markersBefore, int lexemeIndex) {
        for (int k = markersBefore - 1; k > 1; --k) {
            boolean done;
            int id = this.getInt(k);
            FleetPsiBuilder.ProductionMarker marker = (FleetPsiBuilder.ProductionMarker)this.myPool.get(Math.abs(id));
            boolean bl = done = id < 0;
            if (marker.getLexemeIndex(done) < lexemeIndex) break;
            marker.setLexemeIndex(lexemeIndex, done);
        }
    }

    void doHeavyChecksOnMarkerDone(@NotNull FleetPsiBuilder.StartMarker doneMarker, @Nullable FleetPsiBuilder.StartMarker anchorBefore) {
        int idx = this.indexOf(doneMarker);
        int endIdx = this.size();
        if (anchorBefore != null && idx > (endIdx = this.indexOf(anchorBefore))) {
            LOG.error("'Before' marker precedes this one.");
        }
        for (int i = endIdx - 1; i > idx; --i) {
            Throwable debugAllocOther;
            FleetPsiBuilder.StartMarker otherMarker;
            FleetPsiBuilder.ProductionMarker item = this.getStartMarkerAt(i);
            if (!(item instanceof FleetPsiBuilder.StartMarker) || (otherMarker = (FleetPsiBuilder.StartMarker)item).isDone()) continue;
            Throwable debugAllocThis = this.myOptionalData.getAllocationTrace(doneMarker);
            Throwable currentTrace = new Throwable();
            if (debugAllocThis != null) {
                MarkerProduction.makeStackTraceRelative(debugAllocThis, currentTrace).printStackTrace(System.err);
            }
            if ((debugAllocOther = this.myOptionalData.getAllocationTrace(otherMarker)) != null) {
                MarkerProduction.makeStackTraceRelative(debugAllocOther, currentTrace).printStackTrace(System.err);
            }
            LOG.error("Another not done marker added after this one. Must be done before this.");
        }
    }

    @NotNull
    private static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        return th;
    }

    void assertNoDoneMarkerAround(@NotNull FleetPsiBuilder.StartMarker pivot) {
        int pivotIndex = this.indexOf(pivot);
        for (int i = pivotIndex + 1; i < this.size(); ++i) {
            FleetPsiBuilder.StartMarker m = this.getDoneMarkerAt(i);
            if (m != null && m.myLexemeIndex <= pivot.myLexemeIndex && this.indexOf(m) < pivotIndex) {
                throw new AssertionError("There's a marker of type '" + String.valueOf(m.getTokenType()) + "' that starts before and finishes after the current marker. See cause for its allocation trace.", this.myOptionalData.getAllocationTrace(m));
            }
        }
    }
}

