/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.TokenWrapper;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.ITokenSequence;
import com.intellij.psi.TokenType;
import com.intellij.psi.builder.MarkerOptionalData;
import com.intellij.psi.builder.MarkerPool;
import com.intellij.psi.builder.MarkerProduction;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FleetPsiBuilder<N>
extends UserDataHolderBase
implements PsiBuilder {
    static final Logger LOG = Logger.getInstance(FleetPsiBuilder.class);
    int myCurrentLexemeIndex;
    private final Lexeme myCurrentLexeme = new Lexeme();
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    final CharSequence myText;
    private boolean myDebugMode;
    final int myLexemeCount;
    boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private IElementType myCachedTokenType;
    private final MarkerPool myPool = new MarkerPool(this);
    final MarkerOptionalData myOptionalData = new MarkerOptionalData();
    final MarkerProduction myProduction = new MarkerProduction(this.myPool, this.myOptionalData);
    public final ITokenSequence myTokens;
    final int myStartLexeme;
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";

    public FleetPsiBuilder(@NotNull CharSequence text, @NotNull ITokenSequence tokens, @NotNull TokenSet whitespaceTokens, @NotNull TokenSet commentTokens, int startLexeme, int lexemeCount) {
        this.myText = text;
        this.myStartLexeme = startLexeme;
        this.myWhitespaces = whitespaceTokens;
        this.myComments = commentTokens;
        this.myTokens = tokens;
        this.myLexemeCount = lexemeCount + startLexeme;
        this.myCurrentLexemeIndex = startLexeme;
        this.updateCurrentLexeme();
    }

    @NotNull
    public abstract N getRoot();

    @Override
    public boolean isWhitespaceOrComment(@NotNull IElementType elementType) {
        return this.myWhitespaces.contains(elementType) || this.myComments.contains(elementType);
    }

    @Override
    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        this.myComments = tokens;
    }

    public TokenSet commentTokens() {
        return this.myComments;
    }

    @Override
    @Nullable
    public StartMarker getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            StartMarker marker = this.myProduction.getDoneMarkerAt(index);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker precede(StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "Preceding disposed marker";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.addBefore(pre, marker);
        return pre;
    }

    @Override
    @NotNull
    public CharSequence getOriginalText() {
        return this.myText;
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myCurrentLexeme.tokenType, this.myCurrentLexeme.startOffset, this.myCurrentLexeme.endOffset, this.myText));
        }
        return this.myCurrentLexeme.tokenType;
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myCurrentLexeme.tokenType;
    }

    private IElementType getLexType(int index) {
        return this.myTokens.lexType(index);
    }

    @Override
    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    void updateCurrentLexeme() {
        if (this.myCurrentLexemeIndex < this.myLexemeCount) {
            this.myCurrentLexeme.tokenType = this.myTokens.lexType(this.myCurrentLexemeIndex);
            this.myCurrentLexeme.startOffset = this.myTokens.lexStart(this.myCurrentLexemeIndex);
            this.myCurrentLexeme.endOffset = this.myTokens.lexStart(this.myCurrentLexemeIndex + 1);
        } else {
            this.myCurrentLexeme.tokenType = TokenType.BAD_CHARACTER;
            this.myCurrentLexeme.endOffset = this.myCurrentLexeme.startOffset = this.myTokens.lexStart(this.myCurrentLexemeIndex);
        }
    }

    @Override
    public void remapCurrentToken(IElementType type) {
        if (this.myCurrentLexemeIndex < this.myLexemeCount) {
            this.myTokens.remap(this.myCurrentLexemeIndex, type);
            this.updateCurrentLexeme();
            this.clearCachedTokenType();
        }
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        int cur = this.shiftOverWhitespaceForward(this.myCurrentLexemeIndex);
        while (steps > 0) {
            cur = this.shiftOverWhitespaceForward(cur + 1);
            --steps;
        }
        return cur < this.myLexemeCount ? this.getLexType(cur) : null;
    }

    private int shiftOverWhitespaceForward(int lexIndex) {
        while (lexIndex < this.myLexemeCount && this.whitespaceOrComment(this.getLexType(lexIndex))) {
            ++lexIndex;
        }
        return lexIndex;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexemeIndex + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.getLexType(cur) : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexemeIndex + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.getLexemeStart(cur);
    }

    @Override
    public int rawTokenIndex() {
        return this.myCurrentLexemeIndex;
    }

    @Override
    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback) {
        this.myWhitespaceSkippedCallback = callback;
    }

    @Override
    public void advanceLexer() {
        if (this.eof()) {
            return;
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexemeIndex;
        this.updateCurrentLexeme();
        this.clearCachedTokenType();
    }

    @Override
    public void rawAdvanceLexer(int steps) {
        if (steps < 0) {
            throw new IllegalArgumentException("Steps must be a positive integer - lexer can only be advanced. Use Marker.rollbackTo if you want to rollback PSI building.");
        }
        if (steps == 0) {
            return;
        }
        this.myCurrentLexemeIndex += steps;
        if (this.myCurrentLexemeIndex > this.myLexemeCount || this.myCurrentLexemeIndex < 0) {
            this.myCurrentLexemeIndex = this.myLexemeCount;
        }
        this.myTokenTypeChecked = false;
        this.updateCurrentLexeme();
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexemeIndex < this.myLexemeCount && this.whitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myCurrentLexeme.tokenType, this.myCurrentLexeme.startOffset, this.myCurrentLexemeIndex + 1 < this.myLexemeCount ? this.myCurrentLexeme.endOffset : this.myText.length());
            ++this.myCurrentLexemeIndex;
            this.updateCurrentLexeme();
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type, int start, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type, start, end);
        }
    }

    @Override
    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myCurrentLexeme.startOffset;
    }

    private int getLexemeStart(int idx) {
        return this.myTokens.lexStart(idx);
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type = this.getTokenType();
        if (type instanceof TokenWrapper) {
            return ((TokenWrapper)type).getValue();
        }
        return this.myText.subSequence(this.myCurrentLexeme.startOffset, this.myCurrentLexeme.endOffset).toString();
    }

    public boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexemeIndex);
        this.myProduction.addMarker(marker);
        return marker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.myPool.allocateStartMarker();
        marker.myLexemeIndex = lexemeIndex;
        if (this.myDebugMode) {
            this.myOptionalData.notifyAllocated(marker.markerId);
        }
        return marker;
    }

    @Override
    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexemeIndex >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "The marker is already disposed";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        this.myCurrentLexemeIndex = marker.myLexemeIndex;
        this.updateCurrentLexeme();
        this.myTokenTypeChecked = true;
        this.myProduction.rollbackTo(marker);
        this.clearCachedTokenType();
    }

    private void processDone(@NotNull StartMarker marker, @Nullable String errorMessage, @Nullable StartMarker before) {
        int doneLexeme;
        this.doValidityChecks(marker, before);
        if (errorMessage != null) {
            this.myOptionalData.setErrorMessage(marker.markerId, errorMessage);
        }
        int n = doneLexeme = before == null ? this.myCurrentLexemeIndex : before.myLexemeIndex;
        if (marker.myType.isLeftBound() && this.isEmpty(marker.myLexemeIndex, doneLexeme)) {
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        }
        marker.myDoneLexeme = doneLexeme;
        this.myProduction.addDone(marker, before);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.getLexType(i);
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    private void doValidityChecks(@NotNull StartMarker marker, @Nullable StartMarker before) {
        if (marker.isDone()) {
            LOG.error("Marker already done.");
        }
        if (this.myDebugMode) {
            this.myProduction.doHeavyChecksOnMarkerDone(marker, before);
        }
    }

    @Override
    public void error(@NotNull String messageText) {
        ProductionMarker lastMarker = this.myProduction.getStartMarkerAt(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexemeIndex) {
            return;
        }
        ErrorItem marker = this.myPool.allocateErrorItem();
        marker.myMessage = messageText;
        marker.myLexemeIndex = this.myCurrentLexemeIndex;
        this.myProduction.addMarker(marker);
    }

    void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        this.reportUnbalancedMarkers(marker);
    }

    private void reportUnbalancedMarkers(@Nullable ProductionMarker marker) {
        int index = marker != null ? marker.getStartIndex() + 1 : this.myTokens.getLexemeCount();
        String context = index < this.myTokens.getLexemeCount() ? this.myText.subSequence(Math.max(0, this.getLexemeStart(index) - 1000), this.getLexemeStart(index)) : "<none>";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\ncontext: '" + String.valueOf(context) + "'");
    }

    void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int size = this.myProduction.size() - 1;
        for (int i = 1; i < size; ++i) {
            int wsStartIndex;
            ProductionMarker starting = this.myProduction.getStartMarkerAt(i);
            if (starting instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)starting).isDone(), starting);
            }
            boolean done = starting == null;
            ProductionMarker item = starting != null ? starting : (ProductionMarker)Objects.requireNonNull(this.myProduction.getDoneMarkerAt(i));
            WhitespacesAndCommentsBinder binder = item.getBinder(done);
            int lexemeIndex = item.getLexemeIndex(done);
            boolean recursive = binder instanceof WhitespacesAndCommentsBinder.RecursiveBinder;
            int prevProductionLexIndex = recursive ? 0 : this.myProduction.getLexemeIndexAt(i - 1);
            for (wsStartIndex = Math.max(lexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.whitespaceOrComment(this.getLexType(wsStartIndex - 1)); --wsStartIndex) {
            }
            int wsEndIndex = this.shiftOverWhitespaceForward(lexemeIndex);
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                lexemeIndex = wsStartIndex + binder.getEdgePosition(wsTokens, atEnd, tokenTextGetter);
                item.setLexemeIndex(lexemeIndex, done);
                if (recursive) {
                    this.myProduction.confineMarkersToMaxLexeme(i, lexemeIndex);
                }
            } else if (lexemeIndex < wsStartIndex) {
                lexemeIndex = wsStartIndex;
                item.setLexemeIndex(wsStartIndex, done);
            }
            lastIndex = lexemeIndex;
        }
    }

    @Nullable
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        if (node instanceof ErrorItem) {
            ErrorItem errorNode = (ErrorItem)node;
            return errorNode.myMessage;
        }
        if (node instanceof StartMarker) {
            StartMarker marker = (StartMarker)node;
            if (marker.myType == TokenType.ERROR_ELEMENT) {
                return marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
            }
        }
        return null;
    }

    @Override
    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    @Nullable
    public List<ProductionMarker> getProductions() {
        return new AbstractList<ProductionMarker>(){

            @Override
            public ProductionMarker get(int index) {
                return FleetPsiBuilder.this.myProduction.getMarkerAt(index);
            }

            @Override
            public int size() {
                return FleetPsiBuilder.this.myProduction.size();
            }
        };
    }

    private static class Lexeme {
        IElementType tokenType;
        int startOffset;
        int endOffset;

        private Lexeme() {
        }
    }

    public static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        IElementType myType;
        int myDoneLexeme = -1;
        ProductionMarker myFirstChild;
        ProductionMarker myLastChild;

        StartMarker(int markerId, FleetPsiBuilder<?> builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myBuilder.myOptionalData.clean(this.markerId);
            this.myType = null;
            this.myDoneLexeme = -1;
            this.myLastChild = null;
            this.myFirstChild = null;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.getLexemeStart(this.getEndIndex());
        }

        @Override
        public int getEndIndex() {
            return this.myDoneLexeme;
        }

        @Override
        @NotNull
        WhitespacesAndCommentsBinder getBinder(boolean done) {
            return this.myBuilder.myOptionalData.getBinder(this.markerId, done);
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            if (done) {
                this.myDoneLexeme = lexemeIndex;
            } else {
                this.myLexemeIndex = lexemeIndex;
            }
        }

        @Override
        int getLexemeIndex(boolean done) {
            return done ? this.myDoneLexeme : this.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
            } else {
                this.myLastChild.myNext = node;
            }
            this.myLastChild = node;
        }

        @Override
        @NotNull
        public PsiBuilder.Marker precede() {
            return this.myBuilder.precede(this);
        }

        @Override
        public void drop() {
            this.myBuilder.myProduction.dropMarker(this);
        }

        @Override
        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        @Override
        public void done(@NotNull IElementType type) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.error() instead", (Throwable)new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, null);
        }

        @Override
        public void collapse(@NotNull IElementType type) {
            this.done(type);
            this.myBuilder.myOptionalData.markCollapsed(this.markerId);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.errorBefore() instead", (Throwable)new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, (StartMarker)before);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before, @NotNull String errorMessage) {
            StartMarker marker = (StartMarker)before;
            ErrorItem errorItem = this.myBuilder.myPool.allocateErrorItem();
            errorItem.myMessage = errorMessage;
            errorItem.myLexemeIndex = marker.myLexemeIndex;
            this.myBuilder.myProduction.addBefore(errorItem, marker);
            this.doneBefore(type, marker);
        }

        @Override
        public void error(@NotNull String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, null);
        }

        @Override
        public void errorBefore(@NotNull String message, @NotNull PsiBuilder.Marker before) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, (StartMarker)before);
        }

        @Override
        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, left, false);
            }
            if (right != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, right, true);
            }
        }

        public String toString() {
            if (this.myLexemeIndex < 0) {
                return "<dropped>";
            }
            boolean isDone = this.isDone();
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset();
            int endOffset = isDone ? this.getEndOffset() : this.myBuilder.getCurrentOffset();
            CharSequence text = originalText.subSequence(startOffset, endOffset);
            return isDone ? text.toString() : String.valueOf(text) + "\u2026";
        }

        boolean isDone() {
            return this.myDoneLexeme != -1;
        }
    }

    public static abstract class ProductionMarker
    implements LighterASTNode {
        final int markerId;
        protected final FleetPsiBuilder<?> myBuilder;
        protected int myLexemeIndex = -1;
        protected ProductionMarker myNext;

        ProductionMarker(int markerId, @NotNull FleetPsiBuilder<?> builder) {
            this.markerId = markerId;
            this.myBuilder = builder;
        }

        void clean() {
            this.myLexemeIndex = -1;
            this.myNext = null;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.getLexemeStart(this.myLexemeIndex);
        }

        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @NotNull
        abstract WhitespacesAndCommentsBinder getBinder(boolean var1);

        abstract void setLexemeIndex(int var1, boolean var2);

        abstract int getLexemeIndex(boolean var1);
    }

    static class ErrorItem
    extends ProductionMarker {
        String myMessage;

        ErrorItem(int markerId, FleetPsiBuilder<?> builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        @NotNull
        public WhitespacesAndCommentsBinder getBinder(boolean done) {
            assert (!done);
            return WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            assert (!done);
            this.myLexemeIndex = lexemeIndex;
        }

        @Override
        int getLexemeIndex(boolean done) {
            assert (!done);
            return this.myLexemeIndex;
        }

        @Override
        public int getEndOffset() {
            return this.getStartOffset();
        }

        @Override
        public int getEndIndex() {
            return this.getStartIndex();
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            return TokenType.ERROR_ELEMENT;
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start, int end) {
            this.myStart = start;
            this.mySize = end - start;
        }

        @Override
        public IElementType get(int index) {
            return FleetPsiBuilder.this.getLexType(this.myStart + index);
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start) {
            this.myStart = start;
        }

        @Override
        @NotNull
        public CharSequence get(int i) {
            int idx = this.myStart + i;
            return FleetPsiBuilder.this.myText.subSequence(FleetPsiBuilder.this.myTokens.lexStart(idx), FleetPsiBuilder.this.myTokens.lexStart(idx + 1));
        }
    }
}

