/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.TokenType;
import com.intellij.psi.builder.ASTMarkers;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.IntStream;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.mutable.primitive.MutableIntList;
import kala.range.primitive.IntRange;
import kala.tuple.Unit;
import kala.value.Var;
import kala.value.primitive.MutableIntValue;
import org.aya.kala.Int2IntOpenHashMap;
import org.aya.kala.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ASTMarkersImpl<T>
implements ASTMarkers<T> {
    private static final int DEFAULT_CAPACITY = 256;
    @NotNull
    private final Packer packer;
    @NotNull
    private final MutableList<IElementType> elementTypes;
    @NotNull
    private final Int2ObjectOpenHashMap<String> errorMessages;
    @NotNull
    private final Int2ObjectOpenHashMap<AtomicReference<T>> chameleonsMap;
    private int nextId;

    public ASTMarkersImpl() {
        this.packer = new Packer();
        this.elementTypes = MutableArrayList.create((int)256);
        this.errorMessages = new Int2ObjectOpenHashMap();
        this.chameleonsMap = new Int2ObjectOpenHashMap();
        this.nextId = 0;
    }

    private ASTMarkersImpl(@NotNull ASTMarkersImpl<T> origin) {
        this.packer = origin.packer.copy();
        this.elementTypes = MutableArrayList.from(origin.elementTypes);
        this.errorMessages = origin.errorMessages.clone();
        this.chameleonsMap = origin.chameleonsMap.clone();
        this.nextId = origin.nextId;
    }

    @Override
    public int getSize() {
        return this.packer.size();
    }

    @Override
    public byte kind(int i) {
        return this.packer.kind(i);
    }

    @Override
    @Nullable
    public String errorMessage(int i) {
        return this.hasError(i) ? (String)this.errorMessages.get(this.id(i)) : null;
    }

    boolean hasError(int i) {
        return this.packer.hasError(i);
    }

    int id(int i) {
        return this.packer.id(i);
    }

    @Override
    public int lexemeCount(int i) {
        return this.packer.lexemeInfo((int)i).count;
    }

    @Override
    public int lexemeRelOffset(int i) {
        return this.packer.lexemeInfo((int)i).relOffset;
    }

    @Override
    public boolean collapsed(int i) {
        return this.packer.collapsed(i);
    }

    @Override
    public int markersCount(int i) {
        return this.packer.markersCount(i);
    }

    @Override
    @NotNull
    public IElementType elementType(int i) {
        return (IElementType)this.elementTypes.get(i);
    }

    @Override
    @NotNull
    public AtomicReference<T> chameleonAt(int lexemeIndex) {
        return (AtomicReference)this.chameleonsMap.get(lexemeIndex);
    }

    @Override
    @NotNull
    public List<Pair<Integer, AtomicReference<T>>> chameleons() {
        return this.chameleonsMap.toList();
    }

    private void substituteImpl(@NotNull ASTMarkers<T> preAstMarkers, int i, int lexemeIndex) {
        if (!(preAstMarkers instanceof ASTMarkersImpl)) {
            throw new AssertionError((Object)("unexpected class: " + String.valueOf(preAstMarkers.getClass())));
        }
        ASTMarkersImpl astMarkers = (ASTMarkersImpl)preAstMarkers;
        ASTMarkers.check(this.kind(i) == 1, "");
        int start = i;
        int end = i + this.markersCount(i);
        int relOffset = this.lexemeRelOffset(i);
        Int2IntOpenHashMap oldId2newId = new Int2IntOpenHashMap();
        this.copyNewChameleons(lexemeIndex, astMarkers);
        this.removeMarkersFromMaps(start, end);
        int newNextId = this.computeIdsForNewMarkers(astMarkers, oldId2newId);
        this.copyNewAstMarkers(start, end, astMarkers);
        this.renumberIfNeeded(newNextId, start, start + astMarkers.getSize());
        this.renumberNewMarkers(start, oldId2newId, astMarkers);
        int count = this.lexemeCount(i);
        this.setLexemeInfo(i, count, relOffset);
        this.setLexemeInfo(i + astMarkers.getSize() - 1, count, relOffset);
        this.nextId += newNextId;
    }

    private void copyNewChameleons(int startLexeme, @NotNull ASTMarkersImpl<T> astMarkers) {
        this.chameleonsMap.keySet().stream().filter(it -> startLexeme <= it && it < startLexeme + astMarkers.lexemeCount(0)).forEach(this.chameleonsMap::remove);
        astMarkers.chameleonsMap.forEach((k, v) -> this.chameleonsMap.put(k + startLexeme, (AtomicReference<T>)v));
    }

    private void renumberNewMarkers(int start, @NotNull Int2IntOpenHashMap oldId2newId, @NotNull ASTMarkersImpl<T> astMarkers) {
        int offset = this.nextId;
        IntStream.range(start, start + astMarkers.getSize()).forEach(index -> {
            int oldId = this.id(index);
            int newId = (Integer)oldId2newId.get(oldId) + offset;
            if (this.hasError(index)) {
                this.errorMessages.put(newId, (String)astMarkers.errorMessages.get(oldId));
            }
            this.packer.setId(index, newId);
        });
    }

    private int computeIdsForNewMarkers(@NotNull ASTMarkersImpl<T> astMarkers, @NotNull Int2IntOpenHashMap oldId2newId) {
        Var nextNewId = new Var((Object)0);
        IntStream.range(0, astMarkers.getSize()).forEach(index -> oldId2newId.computeIfAbsent(astMarkers.id(index), i -> {
            Integer n = (Integer)nextNewId.value;
            nextNewId.value = (Integer)nextNewId.value + 1;
            return n;
        }));
        return (Integer)nextNewId.value;
    }

    private void renumberIfNeeded(int nextNewId, int insertedStart, int insertedEnd) {
        if (this.packer.shortMode() && this.nextId + nextNewId > 65535) {
            this.nextId = 0;
            this.renumber(insertedStart, insertedEnd);
        }
    }

    private void copyNewAstMarkers(int start, int end, @NotNull ASTMarkersImpl<?> astMarkers) {
        this.elementTypes.removeInRange(start, end + 1);
        this.elementTypes.insertAll(start, (Object[])((IElementType[])astMarkers.elementTypes.toArray((Object[])IElementType.EMPTY_ARRAY)));
        this.packer.replace(start, end + 1, astMarkers.packer);
    }

    private void removeMarkersFromMaps(int start, int end) {
        IntRange.closed((int)start, (int)end).forEach(index -> {
            int currentId = this.id(index);
            if (this.hasError(index)) {
                this.errorMessages.remove(currentId);
            }
        });
    }

    private void renumber(int insertedStart, int insertedEnd) {
        Int2IntOpenHashMap renumberMap = new Int2IntOpenHashMap();
        IntStream.range(0, this.getSize()).forEach(index -> {
            if (index >= insertedStart && index < insertedEnd) {
                return;
            }
            Integer newId = renumberMap.computeIfAbsent(this.id(index), oldId -> {
                int currentId = this.nextId++;
                if (this.hasError(index)) {
                    this.errorMessages.put(currentId, (String)this.errorMessages.remove(oldId));
                }
                return currentId;
            });
            this.packer.setId(index, newId);
        });
    }

    void setChameleon(int lexemeIndex, @NotNull AtomicReference<T> chameleon) {
        this.chameleonsMap.put(lexemeIndex, chameleon);
    }

    void setMarkersCount(int i, int descCount) {
        this.packer.setMarkersCount(i, descCount);
    }

    void setLexemeInfo(int i, int lexemeCount, int relOffset) {
        this.packer.setLexemeInfo(i, lexemeCount, relOffset);
    }

    int pushBack() {
        int i = this.getSize();
        this.packer.pushBack();
        this.elementTypes.insert(i, (Object)TokenType.ERROR_ELEMENT);
        return i;
    }

    void setMarker(int index, int id, byte kind, boolean collapsed, @Nullable String errorMessage, @Nullable IElementType elementType) {
        if (this.kind(index) != 0) {
            throw new AssertionError();
        }
        if (id + 1 > this.nextId) {
            this.nextId = id + 1;
        }
        this.packer.setInitialInfo(index, id, kind, collapsed, errorMessage != null);
        if (errorMessage != null) {
            this.errorMessages.put(id, errorMessage);
        }
        if (elementType != null) {
            this.elementTypes.set(index, (Object)elementType);
        }
    }

    @Override
    @NotNull
    public ASTMarkers<T> mutate(@NotNull Function<ASTMarkers.MutableContext<T>, Unit> mutator) {
        MutableContextImpl<T> ctx = new MutableContextImpl<T>(new ASTMarkersImpl<T>(this));
        mutator.apply(ctx);
        return ctx.ast;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        MutableIntValue depth = MutableIntValue.create((int)0);
        this.elementTypes.forEachIndexed((index, type) -> {
            if (this.kind(index) == 2) {
                depth.decrement();
            }
            ASTMarkers.repeat(depth.get(), i -> b.append(" "));
            b.append(type).append(" ").append(this.kind(index)).append(" ");
            b.append("e=").append(this.hasError(index)).append(" ");
            b.append("c=").append(this.collapsed(index)).append(" ");
            b.append("lo=").append(this.lexemeRelOffset(index)).append(" ");
            b.append("lc=").append(this.lexemeCount(index)).append(" ");
            b.append("mc=").append(this.markersCount(index)).append("\n");
            if (this.kind(index) == 1) {
                depth.increment();
            }
        });
        b.append("{").append("\n");
        this.chameleonsMap.forEach((t, u) -> b.append(t).append(" -> ").append(u.get()).append("\n"));
        b.append("}").append("\n");
        return b.toString();
    }

    private static class Packer {
        private static final int KIND_MASK = 3;
        private static final int MAX_SHORT_ID_VALUE = 65535;
        private static final int MAX_SHORT_LEXEME_VALUE = 65535;
        private static final int MAX_SHORT_MARKERS_COUNT = 4095;
        private static final int MAX_LONG_MARKERS_COUNT = 0xFFFFFFF;
        private final MutableIntList ints;
        private boolean longMode = false;

        private boolean shortMode() {
            return !this.longMode;
        }

        public Packer() {
            this.ints = MutableIntArrayList.create((int)256);
        }

        private Packer(@NotNull Packer origin) {
            this.longMode = origin.longMode;
            this.ints = MutableIntArrayList.from((IntTraversable)origin.ints);
        }

        private int index(int i) {
            return this.longMode ? i * 4 : i * 2;
        }

        byte kind(int i) {
            return (byte)(this.ints.get(this.index(i)) & 3);
        }

        @NotNull
        LexemeInfo lexemeInfo(int i) {
            int index = this.index(i);
            if (this.longMode) {
                return new LexemeInfo(this.ints.get(index + 2), this.ints.get(index + 3));
            }
            int packed = this.ints.get(index + 1);
            return new LexemeInfo(packed & 0xFFFF, packed >>> 16);
        }

        boolean collapsed(int i) {
            return (this.ints.get(this.index(i)) & 4) == 4;
        }

        boolean hasError(int i) {
            return (this.ints.get(this.index(i)) & 8) == 8;
        }

        int id(int i) {
            int index = this.index(i);
            return this.longMode ? this.ints.get(index + 1) : this.ints.get(index) >>> 16;
        }

        int markersCount(int i) {
            return this.ints.get(this.index(i)) >>> 4 & (this.longMode ? 0xFFFFFFF : 4095);
        }

        int size() {
            return this.ints.size() / (this.longMode ? 4 : 2);
        }

        void setLexemeInfo(int i, int count, int relOffset) {
            if (this.shortMode() && (relOffset > 65535 || count > 65535)) {
                this.grow();
            }
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 2, relOffset);
                this.ints.set(index + 3, count);
            } else {
                this.ints.set(index + 1, relOffset | count << 16);
            }
        }

        void setMarkersCount(int i, int count) {
            if (this.shortMode() && count > 4095) {
                this.grow();
            }
            ASTMarkers.check(count <= 0xFFFFFFF, "markers count $count is bigger than $MAX_LONG_MARKERS_COUNT");
            int index = this.index(i);
            this.ints.set(index, this.ints.get(index) & 0xFFFF000F | count << 4);
        }

        void setInitialInfo(int i, int id, byte kind, boolean collapsed, boolean hasErrors) {
            int hasErrorInt;
            int collapsedInt = collapsed ? 4 : 0;
            int n = hasErrorInt = hasErrors ? 8 : 0;
            if (this.shortMode() && id > 65535) {
                this.grow();
            }
            int index = this.index(i);
            this.ints.set(index, kind + collapsedInt + hasErrorInt);
            this.setId(i, id);
        }

        void setId(int i, int id) {
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 1, id);
            } else {
                this.ints.set(index, this.ints.get(index) & 0xFFFF | id << 16);
            }
        }

        void replace(int start, int end, @NotNull Packer packer) {
            if (this.longMode && !packer.longMode) {
                packer.grow();
            }
            if (!this.longMode && packer.longMode) {
                this.grow();
            }
            this.ints.removeInRange(this.index(start), this.index(end));
            this.ints.insertAll(this.index(start), packer.ints.toArray());
        }

        private void grow() {
            ASTMarkers.check(this.shortMode(), "Already in long mode");
            int end = this.size() - 1;
            ASTMarkers.repeat(this.ints.size(), i -> this.ints.append(0));
            this.longMode = true;
            ASTMarkers.downTo(end, 0, i -> {
                int firstInt = this.ints.get(i * 2);
                int secondInt = this.ints.get(i * 2 + 1);
                this.setInitialInfo(i, firstInt >>> 16, (byte)(firstInt & 3), (firstInt & 4) == 4, (firstInt & 8) == 8);
                this.setMarkersCount(i, firstInt >>> 4 & 0xFFF);
                this.setLexemeInfo(i, secondInt >>> 16, secondInt & 0xFFFF);
            });
        }

        void pushBack() {
            ASTMarkers.repeat(this.longMode ? 4 : 2, i -> this.ints.append(0));
        }

        @NotNull
        Packer copy() {
            return new Packer(this);
        }
    }

    record LexemeInfo(int relOffset, int count) {
    }

    record MutableContextImpl<T>(@NotNull ASTMarkersImpl<T> ast) implements ASTMarkers.MutableContext<T>
    {
        @Override
        public void substitute(int i, int lexemeIndex, @NotNull ASTMarkers<T> astMarkers) {
            this.ast.substituteImpl(astMarkers, i, lexemeIndex);
        }

        @Override
        public void changeChameleons(@NotNull List<Pair<Integer, AtomicReference<T>>> pairs) {
            this.ast.chameleonsMap.clear();
            pairs.forEach(kv -> this.ast.chameleonsMap.put((Integer)kv.first, (AtomicReference)kv.second));
        }

        @Override
        public void changeLexCount(int startMarker, int endMarker, int lexCount) {
            int relOffset = this.ast.lexemeRelOffset(startMarker);
            this.ast.setLexemeInfo(startMarker, lexCount, relOffset);
            this.ast.setLexemeInfo(endMarker, lexCount, relOffset);
        }

        @Override
        public void changeMarkerCount(int startMarker, int endMarker, int markerCount) {
            this.ast.setMarkersCount(startMarker, markerCount);
            this.ast.setMarkersCount(endMarker, markerCount);
        }
    }
}

