package com.intellij.psi.impl.source.codeStyle;

import com.intellij.psi.ITokenSequence;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class LexemeIteratorImpl implements LexemeIterator {

  @NotNull
  private final ITokenSequence myTokenSequence;
  private int myIndex;

  public LexemeIteratorImpl(@NotNull ITokenSequence tokenSequence,
                            int offset) {
    myTokenSequence = tokenSequence;
    myIndex = tokenSequence.lexemeIndexByChar(offset);
  }

  @Override
  public int getStart() {
    return myTokenSequence.lexStart(myIndex);
  }

  @Override
  public int getEnd() {
    return myTokenSequence.lexStart(myIndex + 1);
  }

  @Override
  public IElementType getTokenType() {
    return myTokenSequence.lexType(myIndex);
  }

  @Override
  public void advance() {
    myIndex++;
  }

  @Override
  public void retreat() {
    myIndex--;
  }

  @Override
  public boolean atEnd() {
    return myIndex >= myTokenSequence.getLexemeCount() || myIndex < 0;
  }

  public static class Wrapper implements LexemeIterator {
    private final LexemeIterator myLexemeIterator;

    public Wrapper(@NotNull LexemeIterator lexemeIterator) {
      myLexemeIterator = lexemeIterator;
    }

    @Override
    public int getStart() {
      return myLexemeIterator.getStart();
    }

    @Override
    public int getEnd() {
      return myLexemeIterator.getEnd();
    }

    @Override
    public IElementType getTokenType() {
      return myLexemeIterator.getTokenType();
    }

    @Override
    public void advance() {
    }

    @Override
    public void retreat() {
    }

    @Override
    public boolean atEnd() {
      return myLexemeIterator.atEnd();
    }
  }
}
