// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import org.jetbrains.annotations.NotNull;

/**
 * Kind of file types capable to provide {@link Language}.
 */
public abstract class LanguageFileType implements FileType {
  private final Language myLanguage;

  /**
   * Creates a language file type for the specified language.
   *
   * @param language The language used in the files of the type.
   */
  protected LanguageFileType(@NotNull Language language) {
    myLanguage = language;
  }

  /**
   * Returns the language used in the files of the type.
   *
   * @return The language instance.
   */
  @NotNull
  public final Language getLanguage() {
    return myLanguage;
  }
}
