package com.intellij.core;

import com.intellij.util.BundleHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.util.ResourceBundle;

public class CoreBundle {
  public static final @NonNls String BUNDLE = "messages.CoreBundle";

  private static final ResourceBundle INSTANCE = ResourceBundle.getBundle(BUNDLE);

  private CoreBundle() {
  }

  @NotNull
  public static String message(String name, Object... objects) {
    return BundleHelper.message(INSTANCE, name, objects);
  }
}
