/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="entrySet().toArray()")
@ApiStatus.NonExtendable
public class MultiMap<K, V>
implements Serializable {
    @Deprecated
    public static final MultiMap<?, ?> EMPTY = new EmptyMap();
    private static final long serialVersionUID = -2632269270151455493L;
    protected final Map<K, Collection<V>> myMap;
    private Collection<V> values;

    public MultiMap() {
        this.myMap = this.createMap();
    }

    public MultiMap(@NotNull Map<K, Collection<V>> map) {
        this.myMap = map;
    }

    public MultiMap(int expectedSize) {
        this.myMap = new HashMap<K, Collection<V>>(expectedSize);
    }

    public MultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
        this();
        this.putAllValues(toCopy);
    }

    @NotNull
    public MultiMap<K, V> copy() {
        return new MultiMap<K, V>(this);
    }

    public MultiMap(int initialCapacity, float loadFactor) {
        this.myMap = new HashMap<K, Collection<V>>(initialCapacity, loadFactor);
    }

    @Deprecated
    @NotNull
    protected Map<K, Collection<V>> createMap() {
        return new HashMap();
    }

    @NotNull
    protected Collection<V> createCollection() {
        return new SmartList();
    }

    @NotNull
    protected Collection<V> createEmptyCollection() {
        return Collections.emptyList();
    }

    public final void putAllValues(@NotNull MultiMap<? extends K, ? extends V> from) {
        for (Map.Entry<K, Collection<V>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    @NotNull
    public final Map<K, Collection<V>> toHashMap() {
        Map<K, Collection<V>> map = this.myMap;
        if (map instanceof HashMap) {
            HashMap mine = (HashMap)map;
            return (Map)mine.clone();
        }
        return new HashMap<K, Collection<V>>(this.myMap);
    }

    public final void putAllValues(@NotNull Map<? extends K, ? extends V> from) {
        for (Map.Entry<K, V> entry : from.entrySet()) {
            this.putValue(entry.getKey(), entry.getValue());
        }
    }

    public final void putValues(K key, @NotNull Collection<? extends V> values) {
        this.myMap.computeIfAbsent(key, __ -> this.createCollection()).addAll(values);
    }

    public final void putValue(@Nullable K key, V value) {
        this.myMap.computeIfAbsent(key, __ -> this.createCollection()).add(value);
    }

    @NotNull
    public final Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.myMap.entrySet();
    }

    @NotNull
    public final Map<K, Collection<V>> freezeValues() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        this.myMap.replaceAll((k, v) -> Collections.unmodifiableCollection(v));
        return Collections.unmodifiableMap(this.myMap);
    }

    public final boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public final boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public final boolean containsScalarValue(V value) {
        for (Collection<V> valueList : this.myMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        return collection == null ? this.createEmptyCollection() : collection;
    }

    @NotNull
    public final Collection<V> getModifiable(K key) {
        return this.myMap.computeIfAbsent(key, __ -> this.createCollection());
    }

    @NotNull
    public final Set<K> keySet() {
        return this.myMap.keySet();
    }

    public final int size() {
        return this.myMap.size();
    }

    public final void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    @Deprecated
    public final void removeValue(K key, V value) {
        this.remove(key, value);
    }

    public boolean remove(K key, V value) {
        Collection<V> values = this.myMap.get(key);
        if (values == null) {
            return false;
        }
        boolean removed = values.remove(value);
        if (values.isEmpty()) {
            this.myMap.remove(key);
        }
        return removed;
    }

    @NotNull
    public final Collection<V> values() {
        if (this.values != null) {
            return this.values;
        }
        this.values = new AbstractCollection<V>(){

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<Collection<V>> mapIterator;
                    private Iterator<V> itr;
                    {
                        this.mapIterator = MultiMap.this.myMap.values().iterator();
                        this.itr = Collections.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.itr.hasNext()) {
                            if (!this.mapIterator.hasNext()) {
                                return false;
                            }
                            this.itr = this.mapIterator.next().iterator();
                        }
                        return true;
                    }

                    @Override
                    public V next() {
                        while (!this.itr.hasNext()) {
                            if (!this.mapIterator.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            this.itr = this.mapIterator.next().iterator();
                        }
                        return this.itr.next();
                    }

                    @Override
                    public void remove() {
                        this.itr.remove();
                    }
                };
            }

            @Override
            public int size() {
                int res = 0;
                for (Collection vs : MultiMap.this.myMap.values()) {
                    res += vs.size();
                }
                return res;
            }

            @Override
            public boolean contains(Object o) {
                for (Collection vs : MultiMap.this.myMap.values()) {
                    if (!vs.contains(o)) continue;
                    return true;
                }
                return false;
            }
        };
        return this.values;
    }

    public final void clear() {
        this.myMap.clear();
    }

    @Nullable
    public final Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }

    @Deprecated
    @NotNull
    public static <K, V> MultiMap<K, V> emptyInstance() {
        return MultiMap.empty();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        return new MultiMap<K, V>();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createIdentity() {
        return new MultiMap(new IdentityHashMap());
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        return new MultiMap(new LinkedHashMap());
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinkedSet() {
        return new MultiMap<K, V>((Map)new LinkedHashMap()){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new LinkedHashSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                return Collections.emptySet();
            }
        };
    }

    @Deprecated
    @NotNull
    public static <K, V> MultiMap<K, V> createSmart() {
        return new MultiMap<K, V>();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createConcurrent() {
        return new MultiMap<K, V>((Map)new ConcurrentHashMap()){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return ContainerUtil.createLockFreeCopyOnWriteList();
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createConcurrentSet() {
        return new MultiMap<K, V>((Map)new ConcurrentHashMap()){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return Collections.newSetFromMap(new ConcurrentHashMap());
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                return Collections.emptySet();
            }
        };
    }

    public static <K, V> MultiMap<K, V> create(int initialCapacity, float loadFactor) {
        return new MultiMap<K, V>(initialCapacity, loadFactor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MultiMap)) return false;
        MultiMap oo = (MultiMap)o;
        if (!this.myMap.equals(oo.myMap)) return false;
        return true;
    }

    public final int hashCode() {
        return this.myMap.hashCode();
    }

    public final String toString() {
        return this.myMap.toString();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> empty() {
        return EMPTY;
    }

    private static final class EmptyMap
    extends MultiMap<Object, Object> {
        private EmptyMap() {
            super(Collections.emptyMap());
        }
    }
}

