/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedName
implements Comparable<QualifiedName> {
    @NotNull
    private final List<String> myComponents;

    private QualifiedName(int count) {
        this.myComponents = new ArrayList<String>(count);
    }

    public static QualifiedName fromComponents(Collection<String> components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName qName = new QualifiedName(components.size());
        qName.myComponents.addAll(components);
        return qName;
    }

    @NotNull
    public static QualifiedName fromComponents(String ... components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName result = new QualifiedName(components.length);
        Collections.addAll(result.myComponents, components);
        return result;
    }

    public QualifiedName append(String name) {
        QualifiedName result = new QualifiedName(this.myComponents.size() + 1);
        result.myComponents.addAll(this.myComponents);
        result.myComponents.add(name);
        return result;
    }

    public QualifiedName append(QualifiedName qName) {
        QualifiedName result = new QualifiedName(this.myComponents.size() + qName.getComponentCount());
        result.myComponents.addAll(this.myComponents);
        result.myComponents.addAll(qName.getComponents());
        return result;
    }

    @NotNull
    public QualifiedName removeLastComponent() {
        return this.removeTail(1);
    }

    @NotNull
    public QualifiedName removeTail(int count) {
        int size = this.myComponents.size();
        QualifiedName result = new QualifiedName(size);
        result.myComponents.addAll(this.myComponents);
        for (int i = 0; i < count && !result.myComponents.isEmpty(); ++i) {
            result.myComponents.remove(result.myComponents.size() - 1);
        }
        return result;
    }

    @NotNull
    public QualifiedName removeHead(int count) {
        int size = this.myComponents.size();
        QualifiedName result = new QualifiedName(size);
        result.myComponents.addAll(this.myComponents);
        for (int i = 0; i < count && !result.myComponents.isEmpty(); ++i) {
            result.myComponents.remove(0);
        }
        return result;
    }

    @NotNull
    public List<String> getComponents() {
        return this.myComponents;
    }

    public int getComponentCount() {
        return this.myComponents.size();
    }

    public boolean matches(String ... components) {
        if (this.myComponents.size() != components.length) {
            return false;
        }
        for (int i = 0; i < this.myComponents.size(); ++i) {
            if (this.myComponents.get(i).equals(components[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPrefix(QualifiedName prefix) {
        if (this.getComponentCount() < prefix.getComponentCount()) {
            return false;
        }
        for (int i = 0; i < prefix.getComponentCount(); ++i) {
            String component = this.getComponents().get(i);
            if (component != null && component.equals(prefix.getComponents().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(@NotNull String suffix) {
        return suffix.equals(this.getLastComponent());
    }

    @Nullable
    public String getFirstComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(0);
    }

    @Nullable
    public String getLastComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(this.myComponents.size() - 1);
    }

    public String toString() {
        return this.join(".");
    }

    public String join(String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        this.myComponents.forEach(joiner::add);
        return joiner.toString();
    }

    @NotNull
    public static QualifiedName fromDottedString(@NotNull String refName) {
        return QualifiedName.fromComponents(refName.split("\\."));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return this.myComponents.equals(that.myComponents);
    }

    public int hashCode() {
        return this.myComponents.hashCode();
    }

    public QualifiedName subQualifiedName(int fromIndex, int toIndex) {
        return QualifiedName.fromComponents(this.myComponents.subList(fromIndex, toIndex));
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        return this.toString().compareTo(other.toString());
    }

    private static void assertNoDots(@NotNull String component) {
        if (component.contains(".")) {
            throw new IllegalArgumentException("Components of QualifiedName cannot contain dots inside them, but got: " + component);
        }
    }
}

