package com.intellij.analysis;

import com.intellij.util.BundleHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.util.ResourceBundle;

public class AnalysisBundle {
  @NonNls
  private static final String BUNDLE = "messages.AnalysisBundle";
  private static final ResourceBundle INSTANCE = ResourceBundle.getBundle(BUNDLE);

  private AnalysisBundle() {
  }

  @NotNull
  public static String message(String name, Object... objects) {
    return BundleHelper.message(INSTANCE, name, objects);
  }
}
