/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.psi.ITokenSequence;
import com.intellij.psi.impl.source.codeStyle.LexemeIterator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class LexemeIteratorImpl
implements LexemeIterator {
    @NotNull
    private final ITokenSequence myTokenSequence;
    private int myIndex;

    public LexemeIteratorImpl(@NotNull ITokenSequence tokenSequence, int offset) {
        this.myTokenSequence = tokenSequence;
        this.myIndex = tokenSequence.lexemeIndexByChar(offset);
    }

    @Override
    public int getStart() {
        return this.myTokenSequence.lexStart(this.myIndex);
    }

    @Override
    public int getEnd() {
        return this.myTokenSequence.lexStart(this.myIndex + 1);
    }

    @Override
    public IElementType getTokenType() {
        return this.myTokenSequence.lexType(this.myIndex);
    }

    @Override
    public void advance() {
        ++this.myIndex;
    }

    @Override
    public void retreat() {
        --this.myIndex;
    }

    @Override
    public boolean atEnd() {
        return this.myIndex >= this.myTokenSequence.getLexemeCount() || this.myIndex < 0;
    }

    public static class Wrapper
    implements LexemeIterator {
        private final LexemeIterator myLexemeIterator;

        public Wrapper(@NotNull LexemeIterator lexemeIterator) {
            this.myLexemeIterator = lexemeIterator;
        }

        @Override
        public int getStart() {
            return this.myLexemeIterator.getStart();
        }

        @Override
        public int getEnd() {
            return this.myLexemeIterator.getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return this.myLexemeIterator.getTokenType();
        }

        @Override
        public void advance() {
        }

        @Override
        public void retreat() {
        }

        @Override
        public boolean atEnd() {
            return this.myLexemeIterator.atEnd();
        }
    }
}

