/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Lexer {
    public static final long LEXER_START_THRESHOLD = 500L;

    public void start(@NotNull CharSequence var1, int var2, int var3, int var4);

    private void startMeasured(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.start(buffer, startOffset, endOffset, initialState);
    }

    default public void start(@NotNull CharSequence buf, int start, int end) {
        this.startMeasured(buf, start, end, 0);
    }

    default public void start(@NotNull CharSequence buf) {
        this.startMeasured(buf, 0, buf.length(), 0);
    }

    @NotNull
    default public CharSequence getTokenSequence() {
        return this.getBufferSequence().subSequence(this.getTokenStart(), this.getTokenEnd());
    }

    @NotNull
    default public String getTokenText() {
        return this.getTokenSequence().toString();
    }

    public int getState();

    @Nullable
    public IElementType getTokenType();

    public int getTokenStart();

    public int getTokenEnd();

    public void advance();

    @NotNull
    public LexerPosition getCurrentPosition();

    public void restore(@NotNull LexerPosition var1);

    @NotNull
    public CharSequence getBufferSequence();

    public int getBufferEnd();
}

