/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.core.CoreBundle;
import com.intellij.indentation.IndentPsiBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIndentParser
implements PsiParser {
    protected IndentPsiBuilder myBuilder;

    @Override
    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        this.myBuilder = this.createPsiBuilder(builder);
        this.parseRoot(root);
        return this.myBuilder.getTreeBuilt();
    }

    @NotNull
    protected IndentPsiBuilder createPsiBuilder(@NotNull PsiBuilder builder) {
        return new IndentPsiBuilder(builder);
    }

    protected abstract void parseRoot(IElementType var1);

    public PsiBuilder.Marker mark(boolean couldBeRolledBack) {
        if (couldBeRolledBack) {
            return this.myBuilder.markWithRollbackPossibility();
        }
        return this.myBuilder.mark();
    }

    public PsiBuilder.Marker mark() {
        return this.mark(false);
    }

    public void done(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
        marker.done(elementType);
    }

    public static void collapse(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
        marker.collapse(elementType);
    }

    protected static void drop(@NotNull PsiBuilder.Marker marker) {
        marker.drop();
    }

    protected void rollbackTo(@NotNull PsiBuilder.Marker marker) {
        marker.rollbackTo();
    }

    protected boolean eof() {
        return this.myBuilder.eof();
    }

    protected int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }

    public int getCurrentIndent() {
        return this.myBuilder.getCurrentIndent();
    }

    protected void error(@NotNull @NlsContexts.ParsingError String message) {
        this.myBuilder.error(message);
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    protected static boolean tokenIn(@Nullable IElementType elementType, IElementType ... tokens) {
        return ArrayUtil.indexOfIdentity(tokens, elementType) != -1;
    }

    protected boolean currentTokenIn(IElementType ... tokens) {
        return AbstractIndentParser.tokenIn(this.getTokenType(), tokens);
    }

    protected boolean currentTokenIn(@NotNull TokenSet tokenSet) {
        return tokenSet.contains(this.getTokenType());
    }

    @NotNull
    protected String getTokenText() {
        String result = this.myBuilder.getTokenText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    protected boolean expect(@NotNull IElementType elementType) {
        return this.expect(elementType, CoreBundle.message("parsing.error.expected.element", elementType));
    }

    protected boolean expect(@NotNull IElementType elementType, @NotNull @NlsContexts.ParsingError String expectedMessage) {
        if (this.getTokenType() == elementType) {
            this.advance();
            return true;
        }
        this.error(expectedMessage);
        return false;
    }

    @Nullable
    public IElementType lookAhead(int step) {
        return this.myBuilder.lookAhead(step);
    }

    @Nullable
    public IElementType rawLookup(int step) {
        return this.myBuilder.rawLookup(step);
    }

    public boolean isNewLine() {
        return this.myBuilder.isNewLine();
    }

    public void advance() {
        this.myBuilder.advanceLexer();
    }

    public void recalculateCurrentIndent() {
        this.myBuilder.recalculateCurrentIndent(this.getEolElementType(), this.getIndentElementType());
    }

    protected void advanceUntil(TokenSet tokenSet) {
        while (this.getTokenType() != null && !this.isNewLine() && !tokenSet.contains(this.getTokenType())) {
            this.advance();
        }
    }

    protected void advanceUntilEol() {
        this.advanceUntil(TokenSet.EMPTY);
    }

    protected void errorUntil(TokenSet tokenSet, @NotNull @NlsContexts.ParsingError String message) {
        PsiBuilder.Marker errorMarker = this.mark();
        this.advanceUntil(tokenSet);
        errorMarker.error(message);
    }

    protected void errorUntilEol(@NotNull @NlsContexts.ParsingError String message) {
        PsiBuilder.Marker errorMarker = this.mark();
        this.advanceUntilEol();
        errorMarker.error(message);
    }

    protected void errorUntilEof() {
        PsiBuilder.Marker errorMarker = this.mark();
        while (!this.eof()) {
            this.advance();
        }
        errorMarker.error(CoreBundle.message("parsing.error.unexpected.token", new Object[0]));
    }

    protected void expectEolOrEof() {
        if (!this.isNewLine() && !this.eof()) {
            this.errorUntilEol(CoreBundle.message("parsing.error.end.of.line.expected", new Object[0]));
        }
    }

    protected abstract IElementType getIndentElementType();

    protected abstract IElementType getEolElementType();
}

