/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class SmartList<E>
extends AbstractList<E>
implements RandomAccess {
    private int mySize;
    private Object myElem;

    public SmartList() {
    }

    public SmartList(E element) {
        this.myElem = element;
        this.mySize = 1;
    }

    public SmartList(@NotNull Collection<? extends E> elements) {
        int size = elements.size();
        if (size == 1) {
            E element = elements instanceof List && elements instanceof RandomAccess ? ((List)elements).get(0) : elements.iterator().next();
            this.add(element);
        } else if (size > 0) {
            this.mySize = size;
            this.myElem = elements.toArray(new Object[size]);
        }
    }

    @SafeVarargs
    public SmartList(E ... elements) {
        int length = elements.length;
        switch (length) {
            case 0: {
                break;
            }
            case 1: {
                this.myElem = elements[0];
                this.mySize = 1;
                break;
            }
            default: {
                this.myElem = Arrays.copyOf(elements, length);
                this.mySize = length;
            }
        }
    }

    @Override
    public E get(int index) {
        int size = this.mySize;
        SmartList.checkOutOfBounds(index, size);
        if (size == 1) {
            return this.asElement();
        }
        return this.getFromArray(this.asArray(), index);
    }

    private E getFromArray(Object[] objects, int index) {
        return (E)objects[index];
    }

    private static void checkOutOfBounds(int index, int size) {
        Objects.checkIndex(index, size);
    }

    private static void checkOutOfBoundsForAdd(int index, int size) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException(SmartList.outOfBoundsMessage(index, size));
        }
    }

    @NotNull
    private static String outOfBoundsMessage(int index, int size) {
        return "Index: " + index + ", Size: " + size;
    }

    @Override
    public boolean add(E e) {
        int size = this.mySize;
        switch (size) {
            case 0: {
                this.myElem = e;
                break;
            }
            case 1: {
                this.myElem = new Object[]{this.myElem, e};
                break;
            }
            default: {
                Object[] array = this.resizeIfNecessary(size);
                array[size] = e;
            }
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    private Object @NotNull [] resizeIfNecessary(int size) {
        Object[] array = this.asArray();
        int oldCapacity = array.length;
        if (size >= oldCapacity) {
            int newCapacity = Math.max(oldCapacity * 3 / 2 + 1, size + 1);
            array = ArrayUtil.realloc(array, newCapacity, Object[]::new);
            this.myElem = array;
        }
        return array;
    }

    @Override
    public void add(int index, E e) {
        int size = this.mySize;
        SmartList.checkOutOfBoundsForAdd(index, size);
        switch (size) {
            case 0: {
                this.myElem = e;
                break;
            }
            case 1: {
                Object[] objectArray;
                if (index == 0) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = e;
                    objectArray = objectArray2;
                    objectArray2[1] = this.myElem;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = this.myElem;
                    objectArray = objectArray3;
                    objectArray3[1] = e;
                }
                this.myElem = objectArray;
                break;
            }
            default: {
                Object[] array = this.resizeIfNecessary(size);
                System.arraycopy(array, index, array, index + 1, size - index);
                array[index] = e;
            }
        }
        ++this.mySize;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int size = this.mySize;
        int toRemove = toIndex - fromIndex;
        if (toRemove < 0) {
            throw new IndexOutOfBoundsException(SmartList.outOfBoundsMessage(fromIndex, toIndex));
        }
        ++this.modCount;
        if (toRemove == 0) {
            return;
        }
        if (toRemove == size) {
            this.myElem = null;
            this.mySize = 0;
        } else if (toRemove == size - 1) {
            Object[] array = this.asArray();
            this.myElem = array[toRemove * (1 - fromIndex)];
            this.mySize = 1;
        } else {
            Object[] array = this.asArray();
            System.arraycopy(array, toIndex, array, fromIndex, size - toIndex);
            Arrays.fill(array, toIndex, size, null);
            this.mySize = size - toRemove;
        }
    }

    @Override
    public E set(int index, E element) {
        E oldValue;
        int size = this.mySize;
        SmartList.checkOutOfBounds(index, size);
        if (size == 1) {
            oldValue = this.asElement();
            this.myElem = element;
        } else {
            Object[] array = this.asArray();
            oldValue = this.getFromArray(array, index);
            array[index] = element;
        }
        return oldValue;
    }

    private E asElement() {
        return (E)this.myElem;
    }

    private Object[] asArray() {
        return (Object[])this.myElem;
    }

    @Override
    public E remove(int index) {
        E oldValue;
        int size = this.mySize;
        SmartList.checkOutOfBounds(index, size);
        switch (size) {
            case 0: 
            case 1: {
                oldValue = this.asElement();
                this.myElem = null;
                break;
            }
            case 2: {
                Object[] array = this.asArray();
                oldValue = this.getFromArray(array, index);
                this.myElem = array[1 - index];
                break;
            }
            default: {
                Object[] array = this.asArray();
                oldValue = this.getFromArray(array, index);
                int numMoved = size - index - 1;
                if (numMoved > 0) {
                    System.arraycopy(array, index + 1, array, index, numMoved);
                }
                array[size - 1] = null;
            }
        }
        --this.mySize;
        ++this.modCount;
        return oldValue;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.mySize == 0 ? Collections.emptyIterator() : super.iterator();
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.mySize >= 2) {
            Arrays.sort(this.asArray(), 0, this.mySize, comparator);
        }
    }

    @Deprecated
    public int getModificationCount() {
        return this.modCount;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        int aLength = a.length;
        int size = this.mySize;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                E t = this.asElement();
                if (aLength == 0) {
                    T[] r = ArrayUtil.newArray(ArrayUtil.getComponentType(a), 1);
                    r[0] = t;
                    return r;
                }
                a[0] = t;
                break;
            }
            default: {
                if (aLength < size) {
                    return Arrays.copyOf(this.asArray(), size, a.getClass());
                }
                System.arraycopy(this.asArray(), 0, a, 0, size);
            }
        }
        if (aLength > size) {
            a[size] = null;
        }
        return a;
    }

    public void trimToSize() {
        int size = this.mySize;
        if (size < 2) {
            return;
        }
        Object[] array = this.asArray();
        if (size < array.length) {
            ++this.modCount;
            this.myElem = Arrays.copyOf(array, size);
        }
    }

    @Override
    public int indexOf(Object o) {
        return switch (this.mySize) {
            case 0 -> -1;
            case 1 -> {
                if (Objects.equals(o, this.myElem)) {
                    yield 0;
                }
                yield -1;
            }
            default -> ArrayUtilRt.indexOf(this.asArray(), o, 0, this.mySize);
        };
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SmartList) {
            return this.equalsWithSmartList((SmartList)o);
        }
        if (o instanceof ArrayList) {
            return this.equalsWithArrayList((ArrayList)o);
        }
        return super.equals(o);
    }

    private boolean equalsWithSmartList(@NotNull SmartList<?> that) {
        int size = this.mySize;
        if (size != that.mySize) {
            return false;
        }
        return switch (size) {
            case 0 -> true;
            case 1 -> Objects.equals(this.myElem, that.myElem);
            default -> Arrays.equals(this.asArray(), that.asArray());
        };
    }

    private boolean equalsWithArrayList(@NotNull ArrayList<?> that) {
        int size = this.mySize;
        if (size != that.size()) {
            return false;
        }
        return switch (size) {
            case 0 -> true;
            case 1 -> Objects.equals(this.myElem, that.get(0));
            default -> that.equals(this);
        };
    }

    @Override
    public void forEach(@NotNull Consumer<? super E> action) {
        int size = this.mySize;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                action.accept(this.asElement());
                break;
            }
            default: {
                Object[] array = this.asArray();
                for (int i = 0; i < size; ++i) {
                    action.accept(this.getFromArray(array, i));
                }
            }
        }
    }
}

