/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.builder.MarkerNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Objects;
import kala.collection.SeqView;
import kala.text.StringSlice;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GenericNode<N extends GenericNode<N>> {
    @NotNull
    public IElementType elementType();

    @NotNull
    public StringSlice tokenText();

    @NotNull
    public TextRange range();

    @NotNull
    public SeqView<N> childrenView();

    @NotNull
    @NonNls
    default public String toDebugString() {
        return this.toString();
    }

    default public boolean is(@NotNull IElementType type) {
        return this.elementType() == type;
    }

    default public boolean is(@NotNull TokenSet tokenSet) {
        return tokenSet.contains(this.elementType());
    }

    @NotNull
    default public SeqView<N> childrenOfType(@NotNull IElementType type) {
        return this.childrenView().filter(c -> c.is(type));
    }

    @NotNull
    default public SeqView<N> childrenOfType(@NotNull TokenSet tokenSet) {
        return this.childrenView().filter(c -> c.is(tokenSet));
    }

    @Nullable
    default public N peekChild(@NotNull IElementType type) {
        return (N)((GenericNode)this.childrenOfType(type).firstOrNull());
    }

    @Nullable
    default public N peekChild(@NotNull TokenSet tokenSet) {
        return (N)((GenericNode)this.childrenOfType(tokenSet).firstOrNull());
    }

    @NotNull
    default public N child(@NotNull IElementType type) {
        return (N)((GenericNode)Objects.requireNonNull(this.peekChild(type)));
    }

    @NotNull
    default public N child(@NotNull TokenSet tokenSet) {
        return (N)((GenericNode)Objects.requireNonNull(this.peekChild(tokenSet)));
    }

    public record MarkerNodeWrapper(@NotNull MarkerNode node, @NotNull StringSlice tokenText) implements GenericNode<MarkerNodeWrapper>
    {
        public MarkerNodeWrapper(@NotNull String code, @NotNull MarkerNode node) {
            this(node, StringSlice.of((String)code, (int)node.range().getStartOffset(), (int)node.range().getEndOffset()));
        }

        @Override
        @NotNull
        public IElementType elementType() {
            return this.node.elementType();
        }

        @Override
        @NotNull
        public SeqView<MarkerNodeWrapper> childrenView() {
            return this.node.children().view().map(c -> new MarkerNodeWrapper(this.tokenText.source(), (MarkerNode)c));
        }

        @Override
        @NotNull
        public TextRange range() {
            return this.node.range();
        }

        @Override
        @NotNull
        public String toDebugString() {
            return this.node.toDebugString("  ");
        }
    }
}

