/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.ITokenSequence;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ArrayTokenSequence
implements ITokenSequence {
    private static final Logger LOG = Logger.getInstance(ArrayTokenSequence.class);
    private final int[] lexStarts;
    private final IElementType[] lexTypes;
    private final int lexemeCount;

    public ArrayTokenSequence(int[] lexStarts, IElementType[] lexTypes, int lexemeCount) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    @Override
    public int lexStart(int index) {
        return this.lexStarts[index];
    }

    @Override
    @NotNull
    public IElementType lexType(int index) {
        return this.lexTypes[index];
    }

    @Override
    public void remap(int index, @NotNull IElementType type) {
        this.lexTypes[index] = type;
    }

    @Override
    public int getLexemeCount() {
        return this.lexemeCount;
    }

    @Override
    public int lexemeIndexByChar(int offset) {
        for (int index = 0; index < this.getLexemeCount(); ++index) {
            if (this.lexStart(index) > offset || offset >= this.lexStart(index + 1)) continue;
            return index;
        }
        return -1;
    }

    public static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        public Builder(@NotNull CharSequence text, @NotNull Lexer lexer) {
            this.myText = text;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        public ArrayTokenSequence performLexing() {
            IElementType type;
            this.myLexer.start(this.myText);
            int i = 0;
            int offset = 0;
            while ((type = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset) {
                    this.reportDescendingOffsets(i, offset, tokenStart);
                }
                this.myLexStarts[i] = offset = tokenStart;
                this.myLexTypes[i] = type;
                ++i;
                this.myLexer.advance();
            }
            this.myLexStarts[i] = this.myText.length();
            return new ArrayTokenSequence(this.myLexStarts, this.myLexTypes, i);
        }

        private void reportDescendingOffsets(int tokenIndex, int offset, int tokenStart) {
            StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error(sb.toString());
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = Arrays.copyOf(this.myLexStarts, newSize);
            this.myLexTypes = Arrays.copyOf(this.myLexTypes, newSize);
        }
    }
}

