/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.IndentOptions;
import org.jetbrains.annotations.NotNull;

public class IndentInfo {
    private final int mySpaces;
    private final int myIndentSpaces;
    private final int myLineFeeds;
    private final boolean myForceSkipTabulationsUsage;
    private boolean myIndentEmptyLines;

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces) {
        this(lineFeeds, indentSpaces, spaces, false);
    }

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces, boolean forceSkipTabulationsUsage) {
        this.mySpaces = spaces;
        this.myIndentSpaces = indentSpaces;
        this.myLineFeeds = lineFeeds;
        this.myForceSkipTabulationsUsage = forceSkipTabulationsUsage;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    @NotNull
    public String generateNewWhiteSpace(@NotNull IndentOptions options) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.myLineFeeds; ++i) {
            if (options.KEEP_INDENTS_ON_EMPTY_LINES && i > 0) {
                int spaces = this.myIndentEmptyLines ? this.myIndentSpaces + options.INDENT_SIZE : this.myIndentSpaces;
                IndentInfo.generateLineWhitespace(buffer, options, spaces, 0, true);
            }
            buffer.append('\n');
        }
        IndentInfo.generateLineWhitespace(buffer, options, this.myIndentSpaces, this.mySpaces, !this.myForceSkipTabulationsUsage || this.myLineFeeds > 0);
        return buffer.toString();
    }

    private static void generateLineWhitespace(@NotNull StringBuffer buffer, @NotNull IndentOptions options, int indentSpaces, int alignmentSpaces, boolean tabsAllowed) {
        if (options.USE_TAB_CHARACTER && tabsAllowed) {
            if (options.SMART_TABS) {
                int tabCount = indentSpaces / options.TAB_SIZE;
                int leftSpaces = indentSpaces - tabCount * options.TAB_SIZE;
                StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabCount);
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(leftSpaces + alignmentSpaces));
            } else {
                int size = indentSpaces + alignmentSpaces;
                int tabs = size / options.TAB_SIZE;
                int spaces = size % options.TAB_SIZE;
                StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabs);
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
            }
        } else {
            int spaces = indentSpaces + alignmentSpaces;
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
        }
    }

    @NotNull
    IndentInfo setIndentEmptyLines(boolean indentEmptyLines) {
        this.myIndentEmptyLines = indentEmptyLines;
        return this;
    }
}

