/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.LightPsiParser;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.psi.FleetPsiParser;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.builder.MarkerNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultPsiParser
implements FleetPsiParser {
    @NotNull
    private final ParserDefinition parserDefinition;
    @NotNull
    private final LightPsiParser parser;
    @NotNull
    private final Lexer lexer;
    @NotNull
    private final TokenSet whitespaces;
    @NotNull
    private final TokenSet comments;

    protected DefaultPsiParser(@NotNull ParserDefinition parserDefinition) {
        this.parserDefinition = parserDefinition;
        this.parser = (LightPsiParser)((Object)parserDefinition.createParser(null));
        this.lexer = parserDefinition.createLexer(null);
        this.whitespaces = parserDefinition.getWhitespaceTokens();
        this.comments = parserDefinition.getCommentTokens();
    }

    @Override
    public void parse(@NotNull IElementType elementType, @NotNull FleetPsiBuilder<?> builder) {
        this.parser.parseLight(elementType, builder);
    }

    @NotNull
    public MarkerNode parse(@NotNull String text) {
        return this.parse((IElementType)this.parserDefinition.getFileNodeType(), text);
    }

    public void parse(@NotNull FleetPsiBuilder<?> builder) {
        this.parse((IElementType)this.parserDefinition.getFileNodeType(), builder);
    }

    @Override
    @NotNull
    public Lexer getLexer() {
        return this.lexer;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaces() {
        return this.whitespaces;
    }

    @Override
    @NotNull
    public TokenSet getComments() {
        return this.comments;
    }
}

