// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.psi.tree;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.psi.builder.FleetPsiBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * A token type which represents a fragment of text (possibly in a different language)
 * which is not parsed during the current lexer or parser pass and can be parsed later when
 * its contents is requested.
 *
 * @author max
 */

public abstract class ILazyParseableElementType extends IElementType {

  public ILazyParseableElementType(@NotNull @NonNls final String debugName) {
    this(debugName, null);
  }

  public ILazyParseableElementType(@NotNull @NonNls final String debugName, @Nullable final Language language) {
    super(debugName, language);
  }

  /**
   * Allows to construct element types without registering them, as in {@link IElementType#IElementType(String, Language, boolean)}.
   */
  public ILazyParseableElementType(@NotNull @NonNls final String debugName, @Nullable final Language language, final boolean register) {
    super(debugName, language, register);
  }

  /**
   * Returns a lexer for the text fragment or null if the outer tokens could be reused.
   */
  @Nullable
  public Lexer createInnerLexer() {
    return null;
  }

  /**
   * Parses the text fragment using the the provided FleetPsiBuilder
   */
  public abstract void parse(@NotNull FleetPsiBuilder<?> builder);
}
