package com.intellij.openapi.components;

import org.jetbrains.annotations.NotNull;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceManager {
  private static final Map<Class<?>, Object> myServices = new ConcurrentHashMap<>();

  public static <T> T getService(@NotNull Class<T> serviceClass) {
    return (T) myServices.computeIfAbsent(serviceClass, (clazz) -> {
      try {
        return clazz.getConstructor().newInstance();
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    });
  }
}
