package com.intellij.lang;

import org.jetbrains.annotations.NotNull;

import java.util.Collection;

public abstract class MetaLanguage extends Language {
  protected MetaLanguage(@NotNull String ID) {
    super(ID);
  }

  public abstract boolean matchesLanguage(@NotNull Language language);

  @NotNull public Collection<Language> getMatchingLanguages() {
    return Language.getRegisteredLanguages().stream().filter(this::matchesLanguage).toList();
  }
}
