package com.intellij.lang;

import java.util.concurrent.ConcurrentHashMap;

public final class BraceMatchers {
  private static ConcurrentHashMap<Language, PairedBraceMatcher> ourBraceMatchers = new ConcurrentHashMap<>();

  public static PairedBraceMatcher get(Language language) {
    return ourBraceMatchers.get(language);
  }

  public static void register(Language language, PairedBraceMatcher braceMatcher) {
    BraceMatchers.ourBraceMatchers.put(language, braceMatcher);
  }
}