/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.psi.ITokenSequence;
import com.intellij.psi.builder.ASTMarkers;
import com.intellij.psi.builder.ASTMarkersImpl;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.IntStack;
import com.intellij.util.containers.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class MarkerPsiBuilder<T>
extends FleetPsiBuilder<ASTMarkers<T>> {
    private ASTMarkersImpl<T> myTree = null;

    public MarkerPsiBuilder(@NotNull CharSequence text, @NotNull ITokenSequence tokens, @NotNull TokenSet whitespaceTokens, @NotNull TokenSet commentTokens, int startLexeme, int lexemeCount) {
        super(text, tokens, whitespaceTokens, commentTokens, startLexeme, lexemeCount);
    }

    @Override
    @NotNull
    public ASTMarkers<T> getRoot() {
        return this.prepareLightTree();
    }

    @NotNull
    private ASTMarkers<T> prepareLightTree() {
        int i;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if (this.myTree != null) {
            return this.myTree;
        }
        this.myOptionalData.compact();
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        this.myTree = new ASTMarkersImpl();
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        boolean insideChameleon = false;
        int markersInsideChameleon = 0;
        FleetPsiBuilder.StartMarker curNode = null;
        Stack<FleetPsiBuilder.StartMarker> nodes = new Stack<FleetPsiBuilder.StartMarker>();
        IntStack productionIndices = new IntStack();
        IntStack markerIndices = new IntStack();
        for (i = 0; i < this.myProduction.size(); ++i) {
            FleetPsiBuilder.ProductionMarker item = this.myProduction.getStartMarkerAt(i);
            if (item instanceof FleetPsiBuilder.StartMarker) {
                FleetPsiBuilder.StartMarker marker = (FleetPsiBuilder.StartMarker)item;
                if (insideChameleon) {
                    ++markersInsideChameleon;
                    continue;
                }
                int index = this.myTree.pushBack();
                this.myTree.setMarker(index, marker.markerId, (byte)1, this.myOptionalData.isCollapsed(marker.markerId), null, marker.myType);
                if (marker.myType instanceof ILazyParseableElementType && this.myOptionalData.isCollapsed(marker.markerId)) {
                    this.myTree.setChameleon(marker.myLexemeIndex - this.myStartLexeme, new AtomicReference<Object>(null));
                    insideChameleon = true;
                }
                nodes.push(marker);
                markerIndices.push(index);
                productionIndices.push(i);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof FleetPsiBuilder.ErrorItem) {
                FleetPsiBuilder.ErrorItem errorItem = (FleetPsiBuilder.ErrorItem)item;
                int curToken = item.myLexemeIndex;
                if (curToken == lastErrorIndex) continue;
                int prevLexemeIndex = i > 0 ? this.myProduction.getLexemeIndexAt(i - 1) : 0;
                int startLexeme = errorItem.getStartIndex();
                int endLexeme = errorItem.getEndIndex();
                lastErrorIndex = curToken;
                int index = this.myTree.pushBack();
                this.myTree.setMarker(index, errorItem.markerId, (byte)3, false, errorItem.myMessage, errorItem.getTokenType());
                this.myTree.setLexemeInfo(index, endLexeme - startLexeme, startLexeme - prevLexemeIndex);
                continue;
            }
            if (insideChameleon) {
                if (markersInsideChameleon != 0) {
                    --markersInsideChameleon;
                    continue;
                }
                insideChameleon = false;
            }
            this.assertMarkersBalanced(this.myProduction.getDoneMarkerAt(i) == curNode, item);
            curNode = (FleetPsiBuilder.StartMarker)nodes.pop();
            int productionStart = productionIndices.pop();
            int markersStart = markerIndices.pop();
            int prevLexemeIndex = markersStart > 0 ? this.myProduction.getLexemeIndexAt(productionStart - 1) : 0;
            int index = this.myTree.pushBack();
            this.myTree.setMarker(index, curNode.markerId, (byte)2, this.myOptionalData.isCollapsed(curNode.markerId), null, curNode.myType);
            int startLexeme = this.myProduction.getLexemeIndexAt(productionStart);
            int endLexeme = this.myProduction.getLexemeIndexAt(i);
            this.myTree.setLexemeInfo(index, endLexeme - startLexeme, startLexeme - prevLexemeIndex);
            this.myTree.setLexemeInfo(markersStart, endLexeme - startLexeme, startLexeme - prevLexemeIndex);
            this.myTree.setMarkersCount(index, index - markersStart);
            this.myTree.setMarkersCount(markersStart, index - markersStart);
            --curDepth;
        }
        for (i = 0; i < this.myLexemeCount - this.myStartLexeme; ++i) {
            if (!(this.myTokens.lexType(this.myStartLexeme + i) instanceof ILazyParseableElementType)) continue;
            this.myTree.setChameleon(i, new AtomicReference<Object>(null));
        }
        this.clearCachedTokenType();
        return this.myTree;
    }
}

