/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class StringLiteralLexer
implements LexerBase {
    private static final Logger LOG = Logger.getInstance(StringLiteralLexer.class);
    private static final short AFTER_FIRST_QUOTE = 1;
    private static final short AFTER_LAST_QUOTE = 2;
    public static final char NO_QUOTE_CHAR = '\uffff';
    protected CharSequence myBuffer;
    protected int myStart;
    protected int myEnd;
    private int myState;
    private int myLastState;
    protected int myBufferEnd;
    protected final char myQuoteChar;
    protected final IElementType myOriginalLiteralToken;
    private final boolean myCanEscapeEolOrFramingSpaces;
    private final String myAdditionalValidEscapes;
    private boolean mySeenEscapedSpacesOnly;
    private final boolean myAllowOctal;
    private final boolean myAllowHex;

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        this(quoteChar, originalLiteralToken, false, null);
    }

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes) {
        this(quoteChar, originalLiteralToken, canEscapeEolOrFramingSpaces, additionalValidEscapes, true, false);
    }

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes, boolean allowOctal, boolean allowHex) {
        this.myQuoteChar = quoteChar;
        this.myOriginalLiteralToken = originalLiteralToken;
        this.myCanEscapeEolOrFramingSpaces = canEscapeEolOrFramingSpaces;
        this.myAdditionalValidEscapes = additionalValidEscapes;
        this.myAllowOctal = allowOctal;
        this.myAllowHex = allowHex;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myState = this.myQuoteChar == '\uffff' ? 1 : initialState;
        this.myLastState = initialState;
        this.myBufferEnd = endOffset;
        this.myEnd = this.locateToken(this.myStart);
        this.mySeenEscapedSpacesOnly = true;
    }

    @Override
    public int getState() {
        return this.myLastState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (this.myBuffer.charAt(this.myStart) != '\\') {
            this.mySeenEscapedSpacesOnly = false;
            return this.myOriginalLiteralToken;
        }
        if (this.myStart + 1 >= this.myEnd) {
            return this.handleSingleSlashEscapeSequence();
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        this.mySeenEscapedSpacesOnly &= nextChar == ' ';
        if (this.myCanEscapeEolOrFramingSpaces && (nextChar == '\n' || nextChar == ' ' && (this.mySeenEscapedSpacesOnly || this.isTrailingSpace(this.myStart + 2)))) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'u') {
            return this.getUnicodeEscapeSequenceType();
        }
        if (nextChar == 'x' && this.myAllowHex) {
            return this.getHexCodedEscapeSeq();
        }
        switch (nextChar) {
            case '0': {
                if (this.shouldAllowSlashZero()) {
                    return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                }
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                if (!this.myAllowOctal) {
                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
            }
            case '\"': 
            case '\'': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
        }
        if (this.myAdditionalValidEscapes != null && this.myAdditionalValidEscapes.indexOf(nextChar) != -1) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
    }

    protected boolean shouldAllowSlashZero() {
        return false;
    }

    @NotNull
    protected IElementType handleSingleSlashEscapeSequence() {
        return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
    }

    protected IElementType getHexCodedEscapeSeq() {
        return this.getStandardLimitedHexCodedEscapeSeq(4);
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        return this.getStandardLimitedHexCodedEscapeSeq(6);
    }

    @NotNull
    protected IElementType getStandardLimitedHexCodedEscapeSeq(int offsetLimit) {
        for (int i = this.myStart + 2; i < this.myStart + offsetLimit; ++i) {
            if (i < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
    }

    private boolean isTrailingSpace(int start) {
        for (int i = start; i < this.myBufferEnd; i += 2) {
            char c = this.myBuffer.charAt(i);
            if (c != '\\') {
                return false;
            }
            if (i == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTokenStart() {
        return this.myStart;
    }

    @Override
    public int getTokenEnd() {
        return this.myEnd;
    }

    private int locateToken(int start) {
        if (start == this.myBufferEnd) {
            this.myState = 2;
        }
        if (this.myState == 2) {
            return start;
        }
        int i = start;
        if (this.myBuffer.charAt(i) == '\\') {
            LOG.assertTrue(this.myState == 1, (Object)this);
            if (++i == this.myBufferEnd || this.myBuffer.charAt(i) == '\n' && !this.myCanEscapeEolOrFramingSpaces) {
                this.myState = 2;
                return i;
            }
            if (this.myAllowOctal && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                char first = this.myBuffer.charAt(i);
                if (++i < this.myBufferEnd && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7' && ++i < this.myBufferEnd && first <= '3' && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                    ++i;
                }
                return i;
            }
            if (this.myAllowHex && this.myBuffer.charAt(i) == 'x') {
                return this.locateHexEscapeSequence(start, i);
            }
            if (this.myBuffer.charAt(i) == 'u') {
                return this.locateUnicodeEscapeSequence(start, i);
            }
            int additionalLocation = this.locateAdditionalEscapeSequence(start, i);
            if (additionalLocation != -1) {
                return additionalLocation;
            }
            return i + 1;
        }
        LOG.assertTrue(this.myState == 1 || this.myBuffer.charAt(i) == this.myQuoteChar, (Object)this);
        while (i < this.myBufferEnd) {
            if (this.myBuffer.charAt(i) == '\\') {
                return i;
            }
            if (this.myState == 1 && this.myBuffer.charAt(i) == this.myQuoteChar) {
                if (i + 1 == this.myBufferEnd) {
                    this.myState = 2;
                }
                return i + 1;
            }
            ++i;
            this.myState = 1;
        }
        return i;
    }

    protected int locateHexEscapeSequence(int start, int i) {
        ++i;
        while (i < start + 4) {
            if (i == this.myBufferEnd || this.myBuffer.charAt(i) == '\n' || this.myBuffer.charAt(i) == this.myQuoteChar) {
                return i;
            }
            ++i;
        }
        return i;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        ++i;
        while (i < start + 6) {
            if (i == this.myBufferEnd || this.myBuffer.charAt(i) == '\n' || this.myBuffer.charAt(i) == this.myQuoteChar) {
                return i;
            }
            ++i;
        }
        return i;
    }

    protected int locateAdditionalEscapeSequence(int start, int indexOfCharAfterSlash) {
        return -1;
    }

    @Override
    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    public String toString() {
        return "StringLiteralLexer {myAllowHex=" + this.myAllowHex + ", myAllowOctal=" + this.myAllowOctal + ", mySeenEscapedSpacesOnly=" + this.mySeenEscapedSpacesOnly + ", myAdditionalValidEscapes='" + this.myAdditionalValidEscapes + "', myCanEscapeEolOrFramingSpaces=" + this.myCanEscapeEolOrFramingSpaces + ", myOriginalLiteralToken=" + this.myOriginalLiteralToken + ", myQuoteChar=" + this.myQuoteChar + ", myBufferEnd=" + this.myBufferEnd + ", myLastState=" + this.myLastState + ", myState=" + this.myState + ", myEnd=" + this.myEnd + ", myStart=" + this.myStart + ", myToken=" + (this.myBuffer == null || this.myEnd < this.myStart || this.myEnd > this.myBuffer.length() ? null : this.myBuffer.subSequence(this.myStart, this.myEnd)) + "}";
    }
}

