/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import kala.collection.immutable.ImmutableSeq;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NonNls
public interface FlexLexer {
    public void yybegin(int var1);

    public int yystate();

    public int getTokenStart();

    public int getTokenEnd();

    @Nullable
    public IElementType advance() throws IOException;

    @Nullable
    default public IElementType advanceUnchecked() {
        try {
            return this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    default public ImmutableSeq<Token> allTheWayDown() {
        return ImmutableSeq.generateUntilNull(() -> {
            IElementType type = this.advanceUnchecked();
            if (type == null) {
                return null;
            }
            return new Token(new TextRange(this.getTokenStart(), this.getTokenEnd()), type);
        });
    }

    public void reset(CharSequence var1, int var2, int var3, int var4);

    public record Token(@NotNull TextRange range, @NotNull IElementType type) {
    }
}

