/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.builder;

import com.intellij.util.containers.IntStack;

import java.util.ArrayList;

/**
 * @author peter
 */
final class MarkerPool extends ArrayList<FleetPsiBuilder.ProductionMarker> {
  private final FleetPsiBuilder<?> myBuilder;
  private final IntStack myFreeStartMarkers = new IntStack();
  private final IntStack myFreeErrorItems = new IntStack();

  MarkerPool(FleetPsiBuilder<?> builder) {
    myBuilder = builder;
    add(null); //no marker has id 0
  }

  FleetPsiBuilder.StartMarker allocateStartMarker() {
    if (myFreeStartMarkers.size() > 0) {
      return (FleetPsiBuilder.StartMarker) get(myFreeStartMarkers.pop());
    }

    FleetPsiBuilder.StartMarker marker = new FleetPsiBuilder.StartMarker(size(), myBuilder);
    add(marker);
    return marker;
  }

  FleetPsiBuilder.ErrorItem allocateErrorItem() {
    if (myFreeErrorItems.size() > 0) {
      return (FleetPsiBuilder.ErrorItem) get(myFreeErrorItems.pop());
    }

    FleetPsiBuilder.ErrorItem item = new FleetPsiBuilder.ErrorItem(size(), myBuilder);
    add(item);
    return item;
  }

  void freeMarker(FleetPsiBuilder.ProductionMarker marker) {
    marker.clean();
    (marker instanceof FleetPsiBuilder.StartMarker ? myFreeStartMarkers : myFreeErrorItems).push(marker.markerId);
  }

}
