package com.intellij.psi;

import org.aya.ij.AyaModified;
import com.intellij.lexer.Lexer;
import com.intellij.psi.builder.ASTMarkerVisitor;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.builder.MarkerNode;
import com.intellij.psi.builder.MarkerPsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

/** rewrite of FleetPsiParser.kt */
@AyaModified
public interface FleetPsiParser {
  void parse(@NotNull IElementType elementType, @NotNull FleetPsiBuilder<?> builder);

  /** rewrite of `FleetPsiParser.parse(text: String): Node` in AstMarkerVisitor.kt, modified */
  @AyaModified
  default @NotNull MarkerNode parse(@NotNull IElementType elementType, @NotNull String text) {
    var tokens = new ArrayTokenSequence.Builder(text, getLexer()).performLexing();
    var markerPsiBuilder = new MarkerPsiBuilder<>(
      text, tokens, getWhitespaces(), getComments(),
      0, tokens.getLexemeCount());
    parse(elementType, wrap(markerPsiBuilder));
    var root = new MarkerNode(elementType, 0, text.length(), null);
    new ASTMarkerVisitor(this, markerPsiBuilder.getRoot(), getWhitespaces(), getComments(), tokens, text)
      .visitTree(markerPsiBuilder.getRoot(), 0, 0, 0, root);
    return root;
  }

  default <T> @NotNull FleetPsiBuilder<T> wrap(@NotNull FleetPsiBuilder<T> builder) {
    return builder;
  }

  /* override val */
  @NotNull Lexer getLexer();
  /* override val */
  @NotNull TokenSet getWhitespaces();
  /* override val */
  @NotNull TokenSet getComments();
}
