/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TokenSet {
    public static final TokenSet EMPTY = new TokenSet(Short.MAX_VALUE, 0, null);
    public static final TokenSet ANY = TokenSet.forAllMatching(IElementType.TRUE);
    public static final TokenSet WHITE_SPACE = TokenSet.doCreate(TokenType.WHITE_SPACE);
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    @Nullable
    private final IElementType.Predicate myOrCondition;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max, @Nullable IElementType.Predicate orCondition) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
        this.myOrCondition = orCondition;
    }

    private boolean get(int index) {
        int wordIndex = (index >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index) != 0L;
    }

    @Contract(value="null -> false")
    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i <= this.myMax && this.get(i) || this.myOrCondition != null && this.myOrCondition.matches(t);
    }

    public IElementType @NotNull [] getTypes() {
        if (this.myOrCondition != null) {
            return IElementType.enumerate(this::contains);
        }
        IElementType[] types = this.myTypes;
        if (types == null) {
            if (this.myWords.length == 0) {
                types = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list = new ArrayList<IElementType>();
                for (short i = (short)Math.max(1, this.myShift << 6); i <= this.myMax; i = (short)(i + 1)) {
                    IElementType type;
                    if (!this.get(i) || (type = IElementType.find(i)) == null) continue;
                    list.add(type);
                }
                types = list.toArray(IElementType.EMPTY_ARRAY);
            }
            this.myTypes = types;
        }
        return types;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        if (types.length == 0) {
            return EMPTY;
        }
        if (types.length == 1 && types[0] == TokenType.WHITE_SPACE) {
            return WHITE_SPACE;
        }
        return TokenSet.doCreate(types);
    }

    @NotNull
    private static TokenSet doCreate(IElementType ... types) {
        short min = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type : types) {
            if (type == null) continue;
            short index = type.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass(type);
            if (min > index) {
                min = index;
            }
            if (max >= index) continue;
            max = index;
        }
        short shift = (short)(min >> 6);
        TokenSet set = new TokenSet(shift, max, null);
        for (IElementType type : types) {
            int wordIndex;
            if (type == null) continue;
            short index = type.getIndex();
            int n = wordIndex = (index >> 6) - shift;
            set.myWords[n] = set.myWords[n] | 1L << index;
        }
        return set;
    }

    public static TokenSet forAllMatching(@NotNull IElementType.Predicate condition) {
        return new TokenSet(Short.MAX_VALUE, 0, condition);
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets.length == 0) {
            return EMPTY;
        }
        ArrayList<IElementType.Predicate> orConditions = new ArrayList<IElementType.Predicate>();
        ContainerUtil.addIfNotNull(orConditions, sets[0].myOrCondition);
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i = 1; i < sets.length; ++i) {
            if (shift > sets[i].myShift) {
                shift = sets[i].myShift;
            }
            if (max < sets[i].myMax) {
                max = sets[i].myMax;
            }
            ContainerUtil.addIfNotNull(orConditions, sets[i].myOrCondition);
        }
        OrPredicate disjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : new OrPredicate(orConditions));
        TokenSet newSet = new TokenSet(shift, max, disjunction);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i = 0; i < set.myWords.length; ++i) {
                int n = i + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i];
            }
        }
        return newSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a, @NotNull TokenSet b) {
        ArrayList orConditions = new ArrayList();
        ContainerUtil.addIfNotNull(orConditions, a.myOrCondition);
        ContainerUtil.addIfNotNull(orConditions, b.myOrCondition);
        IElementType.Predicate conjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : t -> Objects.requireNonNull(a.myOrCondition).matches(t) && Objects.requireNonNull(b.myOrCondition).matches(t));
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax), conjunction);
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & (0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L);
        }
        return newSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a, @NotNull TokenSet b) {
        IElementType.Predicate difference = a.myOrCondition == null ? null : e -> !b.contains(e) && a.myOrCondition.matches(e);
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax), difference);
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & ((0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return newSet;
    }

    private static class OrPredicate
    implements IElementType.Predicate {
        private final IElementType.Predicate[] myComponents;

        OrPredicate(List<IElementType.Predicate> components) {
            this.myComponents = (IElementType.Predicate[])components.stream().flatMap(p -> p instanceof OrPredicate ? Arrays.stream(((OrPredicate)p).myComponents) : Stream.of(p)).distinct().toArray(IElementType.Predicate[]::new);
        }

        @Override
        public boolean matches(@NotNull IElementType t) {
            for (IElementType.Predicate component : this.myComponents) {
                if (!component.matches(t)) continue;
                return true;
            }
            return false;
        }
    }
}

