/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.ITokenSequence;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IReparseableElementType
extends ILazyParseableElementType {
    public IReparseableElementType(@NotNull @NonNls String debugName) {
        this(debugName, null);
    }

    public IReparseableElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        super(debugName, language);
    }

    public IReparseableElementType(@NotNull @NonNls String debugName, @Nullable Language language, boolean register) {
        super(debugName, language, register);
    }

    public abstract boolean isParsable(@NotNull ITokenSequence var1, int var2, int var3);

    public static boolean hasProperBraceBalance(@NotNull ITokenSequence tokenSequence, int lexIndex, int lexCount, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace) {
        if (tokenSequence.lexType(lexIndex) != leftBrace) {
            return false;
        }
        ++lexIndex;
        --lexCount;
        int balance = 1;
        while (lexCount > 0) {
            ProgressManager.checkCanceled();
            IElementType type = tokenSequence.lexType(lexIndex);
            if (balance == 0) {
                return false;
            }
            if (type == leftBrace) {
                ++balance;
            } else if (type == rightBrace) {
                --balance;
            }
            --lexCount;
            ++lexIndex;
        }
        return balance == 0;
    }
}

