/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.templateLanguages.RangeCollectorImpl;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class TemplateDataModifications {
    public static final TemplateDataModifications EMPTY = new TemplateDataModifications(Collections.emptyList());
    @NotNull
    final List<TextRange> myOuterAndRemoveRanges;

    public TemplateDataModifications() {
        this(new ArrayList<TextRange>());
    }

    private TemplateDataModifications(@NotNull List<TextRange> ranges) {
        this.myOuterAndRemoveRanges = ranges;
    }

    public void addOuterRange(@NotNull TextRange newRange) {
        this.addOuterRange(newRange, false);
    }

    public void addOuterRange(@NotNull TextRange range, boolean isInsertion) {
        this.myOuterAndRemoveRanges.add(isInsertion ? new RangeCollectorImpl.InsertionRange(range.getStartOffset(), range.getEndOffset()) : range);
    }

    public void addRangeToRemove(int startOffset, @NotNull CharSequence textToInsert) {
        this.myOuterAndRemoveRanges.add(new RangeCollectorImpl.RangeToRemove(startOffset, textToInsert));
    }

    @NotNull
    public static TemplateDataModifications fromRangeToRemove(int startOffset, @NotNull CharSequence textToInsert) {
        TemplateDataModifications modifications = new TemplateDataModifications();
        modifications.addRangeToRemove(startOffset, textToInsert);
        return modifications;
    }

    public boolean addAll(@NotNull TemplateDataModifications other) {
        return this.myOuterAndRemoveRanges.addAll(other.myOuterAndRemoveRanges);
    }

    @TestOnly
    @NotNull
    public Pair<CharSequence, TemplateDataElementType.RangeCollector> applyToText(@NotNull CharSequence text, @NotNull TemplateDataElementType anyType) {
        RangeCollectorImpl collector = new RangeCollectorImpl(anyType);
        return Pair.create(collector.applyTemplateDataModifications(text, this), collector);
    }
}

