/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.psi.codeStyle.IndentOptions;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentCalculator {
    @NotNull
    private final BaseLineOffsetCalculator myBaseLineOffsetCalculator;
    @NotNull
    private final IndentOptions myIndentOptions;
    @NotNull
    private final Indent myIndent;
    @NotNull
    private final CharSequence myChars;
    public static final BaseLineOffsetCalculator LINE_BEFORE = currPosition -> CharArrayUtil.shiftBackward(currPosition.getChars(), currPosition.getStartOffset(), " \t\n\r");
    public static final BaseLineOffsetCalculator LINE_AFTER = currPosition -> CharArrayUtil.shiftForward(currPosition.getChars(), currPosition.getStartOffset(), " \t\n\r");

    public IndentCalculator(@NotNull BaseLineOffsetCalculator baseLineOffsetCalculator, @NotNull CharSequence chars, @NotNull IndentOptions indentOptions, @NotNull Indent indent) {
        this.myIndent = indent;
        this.myChars = chars;
        this.myBaseLineOffsetCalculator = baseLineOffsetCalculator;
        this.myIndentOptions = indentOptions;
    }

    @Nullable
    String getIndentString(@NotNull SemanticEditorPosition currPosition) {
        String baseIndent = this.getBaseIndent(currPosition);
        int indentLength = baseIndent.replaceAll("\t", " ".repeat(this.myIndentOptions.TAB_SIZE)).length() + IndentCalculator.indentToSize(this.myIndent, this.myIndentOptions);
        return new IndentInfo(0, indentLength, 0, false).generateNewWhiteSpace(this.myIndentOptions);
    }

    @NotNull
    protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
        int indentEnd;
        int indentStart;
        int indentLineOffset;
        CharSequence docChars = this.myChars;
        int offset = currPosition.getStartOffset();
        if (offset > 0 && (indentLineOffset = this.myBaseLineOffsetCalculator.getOffsetInBaseIndentLine(currPosition)) > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil(docChars, indentLineOffset, "\n") + 1) >= 0 && (indentEnd = CharArrayUtil.shiftForward(docChars, indentStart, " \t")) > indentStart) {
            return docChars.subSequence(indentStart, indentEnd).toString();
        }
        return "";
    }

    private static int indentToSize(@NotNull Indent indent, @NotNull IndentOptions options) {
        if (indent.getType() == Indent.Type.NORMAL) {
            return options.INDENT_SIZE;
        }
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return options.CONTINUATION_INDENT_SIZE;
        }
        if (indent.getType() == Indent.Type.SPACES && indent instanceof IndentImpl) {
            return ((IndentImpl)indent).getSpaces();
        }
        return 0;
    }

    public static interface BaseLineOffsetCalculator {
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition var1);
    }
}

