/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiElement {
    public static final PsiElement[] EMPTY_ARRAY = new PsiElement[0];

    @NotNull
    @Contract(pure=true)
    public Language getLanguage();

    @NotNull
    @Contract(pure=true)
    public PsiElement[] getChildren();

    @Contract(pure=true)
    public PsiElement getParent();

    @Contract(pure=true)
    public PsiElement getFirstChild();

    @Contract(pure=true)
    public PsiElement getLastChild();

    @Contract(pure=true)
    public PsiElement getNextSibling();

    @Contract(pure=true)
    public PsiElement getPrevSibling();

    @Contract(pure=true)
    public PsiFile getContainingFile();

    @Contract(pure=true)
    public TextRange getTextRange();

    @Contract(pure=true)
    public int getStartOffsetInParent();

    @Contract(pure=true)
    public int getTextLength();

    @Nullable
    @Contract(pure=true)
    public PsiElement findElementAt(int var1);

    @Nullable
    @Contract(pure=true)
    public PsiReference findReferenceAt(int var1);

    @Contract(pure=true)
    public int getTextOffset();

    @NonNls
    @Contract(pure=true)
    public String getText();

    @NotNull
    @Contract(pure=true)
    public char[] textToCharArray();

    @Contract(pure=true)
    public PsiElement getNavigationElement();

    @Contract(pure=true)
    public PsiElement getOriginalElement();

    @Contract(pure=true)
    public boolean textMatches(@NotNull @NonNls CharSequence var1);

    @Contract(pure=true)
    public boolean textMatches(@NotNull PsiElement var1);

    @Contract(pure=true)
    public boolean textContains(char var1);

    public PsiElement copy();

    public PsiElement add(@NotNull PsiElement var1);

    public PsiElement addBefore(@NotNull PsiElement var1, @Nullable PsiElement var2);

    public PsiElement addAfter(@NotNull PsiElement var1, @Nullable PsiElement var2);

    @Deprecated
    public void checkAdd(@NotNull PsiElement var1);

    public PsiElement addRange(PsiElement var1, PsiElement var2);

    public PsiElement addRangeBefore(@NotNull PsiElement var1, @NotNull PsiElement var2, PsiElement var3);

    public PsiElement addRangeAfter(PsiElement var1, PsiElement var2, PsiElement var3);

    public void delete();

    @Deprecated
    public void checkDelete();

    public void deleteChildRange(PsiElement var1, PsiElement var2);

    public PsiElement replace(@NotNull PsiElement var1);

    @Contract(pure=true)
    public boolean isValid();

    @Contract(pure=true)
    public boolean isWritable();

    @Nullable
    @Contract(pure=true)
    public PsiReference getReference();

    @Nullable
    @Contract(pure=true)
    public PsiElement getContext();

    @Contract(pure=true)
    public boolean isPhysical();

    @Contract(pure=true)
    public ASTNode getNode();

    @NonNls
    @Contract(pure=true)
    public String toString();

    @Contract(pure=true)
    public boolean isEquivalentTo(PsiElement var1);
}

