/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pair<A, B> {
    public final A first;
    public final B second;
    private static final Pair EMPTY = Pair.create(null, null);

    @NotNull
    public static <A, B> Pair<A, B> create(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    @NotNull
    public static <A, B> NonNull<A, B> createNonNull(@NotNull A first, @NotNull B second) {
        return new NonNull<A, B>(first, second);
    }

    @NotNull
    public static <A, B> Pair<A, B> pair(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    @NotNull
    public static <A, B> Function<A, Pair<A, B>> createFunction(B value) {
        return a -> Pair.create(a, value);
    }

    public static <T> T getFirst(@Nullable Pair<T, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    public static <T> T getSecond(@Nullable Pair<?, T> pair) {
        return pair != null ? (T)pair.second : null;
    }

    @NotNull
    public static <A, B> Pair<A, B> empty() {
        return EMPTY;
    }

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object o) {
        if (!(o instanceof Pair)) return false;
        Pair oo = (Pair)o;
        if (!Comparing.equal(this.first, oo.first)) return false;
        if (!Comparing.equal(this.second, oo.second)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "<" + this.first + "," + this.second + ">";
    }

    public static <A extends Comparable<? super A>, B> Comparator<Pair<A, B>> comparingByFirst() {
        return Comparator.comparing(o -> (Comparable)o.first);
    }

    public static <A, B extends Comparable<? super B>> Comparator<Pair<A, B>> comparingBySecond() {
        return Comparator.comparing(o -> (Comparable)o.second);
    }

    public static class NonNull<A, B>
    extends Pair<A, B> {
        public NonNull(@NotNull A first, @NotNull B second) {
            super(first, second);
        }
    }
}

