package com.intellij.psi.codeStyle;

public class IndentOptions implements Cloneable {
  public static final IndentOptions DEFAULT_INDENT_OPTIONS = new IndentOptions();

  public int INDENT_SIZE = 4;
  public int CONTINUATION_INDENT_SIZE = 8;
  public int TAB_SIZE = 4;
  public boolean USE_TAB_CHARACTER = false;
  public boolean SMART_TABS = false;
  public boolean KEEP_INDENTS_ON_EMPTY_LINES = false;

  // imported from CommonCodeStyle
  public int BRACE_STYLE = -1;
  public int METHOD_BRACE_STYLE = -1;

  private boolean myOverrideLanguageOptions;

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof IndentOptions that)) return false;

    if (CONTINUATION_INDENT_SIZE != that.CONTINUATION_INDENT_SIZE) return false;
    if (INDENT_SIZE != that.INDENT_SIZE) return false;
    if (SMART_TABS != that.SMART_TABS) return false;
    if (TAB_SIZE != that.TAB_SIZE) return false;
    if (USE_TAB_CHARACTER != that.USE_TAB_CHARACTER) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = INDENT_SIZE;
    result = 31 * result + CONTINUATION_INDENT_SIZE;
    result = 31 * result + TAB_SIZE;
    result = 31 * result + (USE_TAB_CHARACTER ? 1 : 0);
    result = 31 * result + (SMART_TABS ? 1 : 0);
    return result;
  }

  public boolean isOverrideLanguageOptions() {
    return myOverrideLanguageOptions;
  }

  public void setOverrideLanguageOptions(boolean overrideLanguageOptions) {
    myOverrideLanguageOptions = overrideLanguageOptions;
  }
}
