package com.intellij.psi;

import com.intellij.AyaModified;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.builder.MarkerNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

@AyaModified
public abstract class DefaultPsiParser implements FleetPsiParser {
  private final @NotNull ParserDefinition parserDefinition;
  private final @NotNull LightPsiParser parser;
  private final /* override val */ @NotNull Lexer lexer;
  private final /* override val */ @NotNull TokenSet whitespaces;
  private final /* override val */ @NotNull TokenSet comments;

  protected DefaultPsiParser(@NotNull ParserDefinition parserDefinition) {
    this.parserDefinition = parserDefinition;
    this.parser = (LightPsiParser) parserDefinition.createParser(null);
    this.lexer = parserDefinition.createLexer(null);
    this.whitespaces = parserDefinition.getWhitespaceTokens();
    this.comments = parserDefinition.getCommentTokens();
  }

  @Override public void parse(@NotNull IElementType elementType, @NotNull FleetPsiBuilder<?> builder) {
    parser.parseLight(elementType, builder);
  }

  public @NotNull MarkerNode parse(@NotNull String text) {
    return parse(parserDefinition.getFileNodeType(), text);
  }

  public void parse(@NotNull FleetPsiBuilder<?> builder) {
    parse(parserDefinition.getFileNodeType(), builder);
  }

  @Override public @NotNull Lexer getLexer() {
    return lexer;
  }

  @Override public @NotNull TokenSet getWhitespaces() {
    return whitespaces;
  }

  @Override public @NotNull TokenSet getComments() {
    return comments;
  }
}
