/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.builder.ASTMarkers;
import com.intellij.psi.tree.IElementType;
import kala.collection.mutable.MutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MarkerNode(@NotNull IElementType elementType, @NotNull TextRange range, @Nullable String text, @Nullable MarkerNode parent, @NotNull MutableList<MarkerNode> children) {
    public MarkerNode(@NotNull IElementType elementType, int startOffset, int endOffset, @Nullable String text, @Nullable MarkerNode parent, @NotNull MutableList<MarkerNode> children) {
        this(elementType, new TextRange(startOffset, endOffset), text, parent, children);
        if (parent != null) {
            parent.children.append((Object)this);
        }
    }

    public MarkerNode(@NotNull IElementType elementType, int startOffset, int endOffset, @Nullable String text, @Nullable MarkerNode parent) {
        this(elementType, startOffset, endOffset, text, parent, (MutableList<MarkerNode>)MutableList.create());
    }

    boolean compareAsToken(MarkerNode node) {
        return this.elementType != node.elementType || !this.range.equals(node.range);
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.elementType + this.range;
    }

    @NotNull
    public String toDebugString(String indentSymbol) {
        StringBuilder builder = new StringBuilder();
        this.toDebugString(0, builder, indentSymbol);
        return builder.toString();
    }

    private void toDebugString(int indent, @NotNull StringBuilder builder, String indentSymbol) {
        ASTMarkers.repeat(indent, i -> builder.append(indentSymbol));
        builder.append(this.elementType).append(this.range).append(System.lineSeparator());
        this.children.forEach(it -> it.toDebugString(indent + 1, builder, indentSymbol));
    }
}

