/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.util.containers.IntStack;
import java.util.ArrayList;

final class MarkerPool
extends ArrayList<FleetPsiBuilder.ProductionMarker> {
    private final FleetPsiBuilder<?> myBuilder;
    private final IntStack myFreeStartMarkers = new IntStack();
    private final IntStack myFreeErrorItems = new IntStack();

    MarkerPool(FleetPsiBuilder<?> builder) {
        this.myBuilder = builder;
        this.add(null);
    }

    FleetPsiBuilder.StartMarker allocateStartMarker() {
        if (this.myFreeStartMarkers.size() > 0) {
            return (FleetPsiBuilder.StartMarker)this.get(this.myFreeStartMarkers.pop());
        }
        FleetPsiBuilder.StartMarker marker = new FleetPsiBuilder.StartMarker(this.size(), this.myBuilder);
        this.add(marker);
        return marker;
    }

    FleetPsiBuilder.ErrorItem allocateErrorItem() {
        if (this.myFreeErrorItems.size() > 0) {
            return (FleetPsiBuilder.ErrorItem)this.get(this.myFreeErrorItems.pop());
        }
        FleetPsiBuilder.ErrorItem item = new FleetPsiBuilder.ErrorItem(this.size(), this.myBuilder);
        this.add(item);
        return item;
    }

    void freeMarker(FleetPsiBuilder.ProductionMarker marker) {
        marker.clean();
        (marker instanceof FleetPsiBuilder.StartMarker ? this.myFreeStartMarkers : this.myFreeErrorItems).push(marker.markerId);
    }
}

