/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntConsumer;
import kala.tuple.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ASTMarkers<T> {
    public int getSize();

    public byte kind(int var1);

    @Nullable
    public String errorMessage(int var1);

    public int lexemeCount(int var1);

    public int lexemeRelOffset(int var1);

    public boolean collapsed(int var1);

    public int markersCount(int var1);

    @NotNull
    public IElementType elementType(int var1);

    @NotNull
    public AtomicReference<T> chameleonAt(int var1);

    @NotNull
    public List<Pair<Integer, AtomicReference<T>>> chameleons();

    @NotNull
    public ASTMarkers<T> mutate(@NotNull Function<MutableContext<T>, Unit> var1);

    default public int prevSibling(int markerIndex) {
        if (markerIndex == 0) {
            return -1;
        }
        int prevMarkerIndex = markerIndex - 1;
        return switch (this.kind(prevMarkerIndex)) {
            case 1 -> -1;
            case 2 -> prevMarkerIndex - this.markersCount(prevMarkerIndex);
            case 3 -> prevMarkerIndex;
            default -> (Integer)ASTMarkers.error("no else");
        };
    }

    default public int nextSibling(int markerIndex) {
        return switch (this.kind(markerIndex)) {
            case 1 -> {
                int endIndex = markerIndex + this.markersCount(markerIndex);
                if (endIndex == this.getSize() - 1) {
                    yield -1;
                }
                int nextToEndIndex = endIndex + 1;
                switch (this.kind(nextToEndIndex)) {
                    case 1: 
                    case 3: {
                        yield nextToEndIndex;
                    }
                    case 2: {
                        yield -1;
                    }
                }
                yield (Integer)ASTMarkers.error("no else");
            }
            case 3 -> {
                byte nextKind = this.kind(markerIndex + 1);
                if (nextKind == 2) {
                    yield -1;
                }
                yield markerIndex + 1;
            }
            case 2 -> (Integer)ASTMarkers.error("should never be at the end");
            default -> (Integer)ASTMarkers.error("no else");
        };
    }

    default public int lastChild(int markerIndex) {
        return switch (this.kind(markerIndex)) {
            case 2 -> (Integer)ASTMarkers.error("never at end");
            case 3 -> -1;
            case 1 -> {
                int prevToEndIndex = markerIndex + this.markersCount(markerIndex) - 1;
                switch (this.kind(prevToEndIndex)) {
                    case 1: {
                        yield -1;
                    }
                    case 2: {
                        yield prevToEndIndex - this.markersCount(prevToEndIndex);
                    }
                    case 3: {
                        yield prevToEndIndex;
                    }
                }
                yield (Integer)ASTMarkers.error("no else");
            }
            default -> (Integer)ASTMarkers.error("no else");
        };
    }

    default public int firstChild(int markerIndex) {
        ASTMarkers.require(markerIndex < this.getSize() - 1, "at least there is an end");
        int nextMarkerIndex = markerIndex + 1;
        return switch (this.kind(nextMarkerIndex)) {
            case 1, 3 -> nextMarkerIndex;
            case 2 -> -1;
            default -> (Integer)ASTMarkers.error("no else");
        };
    }

    public static void require(boolean cond, @NotNull String msg) {
        if (!cond) {
            throw new AssertionError((Object)msg);
        }
    }

    public static void check(boolean cond, @NotNull String msg) {
        if (!cond) {
            throw new AssertionError((Object)msg);
        }
    }

    public static void repeat(int times, @NotNull IntConsumer consumer) {
        for (int i = 0; i < times; ++i) {
            consumer.accept(i);
        }
    }

    public static void downTo(int upper, int lower, @NotNull IntConsumer consumer) {
        for (int i = upper; i >= lower; --i) {
            consumer.accept(i);
        }
    }

    public static <T> T error(@NotNull String error) {
        throw new IllegalStateException(error);
    }

    public static class MarkerKind {
        public static final byte Undone = 0;
        public static final byte Start = 1;
        public static final byte End = 2;
        public static final byte Error = 3;
    }

    public static interface MutableContext<T> {
        public void substitute(int var1, int var2, @NotNull ASTMarkers<T> var3);

        public void changeChameleons(@NotNull List<Pair<Integer, AtomicReference<T>>> var1);

        public void changeLexCount(int var1, int var2, int var3);

        public void changeMarkerCount(int var1, int var2, int var3);
    }
}

