/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Formatter;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.engine.ExpandableIndent;
import org.jetbrains.annotations.NotNull;

final class Holder
implements Formatter {
    private final IndentImpl NONE_INDENT = new IndentImpl(Indent.Type.NONE, false, false);
    private final IndentImpl myAbsoluteNoneIndent = new IndentImpl(Indent.Type.NONE, true, false);
    private final IndentImpl myLabelIndent = new IndentImpl(Indent.Type.LABEL, false, false);
    private final IndentImpl myContinuationIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, true);
    private final IndentImpl myContinuationIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, false);
    private final IndentImpl myContinuationWithoutFirstIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, true);
    private final IndentImpl myContinuationWithoutFirstIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, false);
    private final IndentImpl myAbsoluteLabelIndent = new IndentImpl(Indent.Type.LABEL, true, false);
    private final IndentImpl myNormalIndentRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, true);
    private final IndentImpl myNormalIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, false);
    static volatile Formatter INSTANCE = new Holder();

    Holder() {
    }

    @Override
    public Indent getNormalIndent(boolean relative) {
        return relative ? this.myNormalIndentRelativeToDirectParent : this.myNormalIndentNotRelativeToDirectParent;
    }

    @Override
    public Indent getNoneIndent() {
        return this.NONE_INDENT;
    }

    @Override
    public Indent getSpaceIndent(int spaces, boolean relative) {
        return this.getIndent(Indent.Type.SPACES, spaces, relative, false);
    }

    @Override
    public Indent getIndent(@NotNull Indent.Type type, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        return this.getIndent(type, 0, relativeToDirectParent, enforceIndentToChildren);
    }

    @Override
    public Indent getSmartIndent(@NotNull Indent.Type type) {
        return new ExpandableIndent(type);
    }

    @Override
    public Indent getIndent(@NotNull Indent.Type type, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        return new IndentImpl(type, false, spaces, relativeToDirectParent, enforceIndentToChildren);
    }

    @Override
    public Indent getAbsoluteLabelIndent() {
        return this.myAbsoluteLabelIndent;
    }

    @Override
    public Indent getAbsoluteNoneIndent() {
        return this.myAbsoluteNoneIndent;
    }

    @Override
    public Indent getLabelIndent() {
        return this.myLabelIndent;
    }

    @Override
    public Indent getContinuationIndent(boolean relative) {
        return relative ? this.myContinuationIndentRelativeToDirectParent : this.myContinuationIndentNotRelativeToDirectParent;
    }

    @Override
    public Indent getContinuationWithoutFirstIndent(boolean relative) {
        return relative ? this.myContinuationWithoutFirstIndentRelativeToDirectParent : this.myContinuationWithoutFirstIndentNotRelativeToDirectParent;
    }
}

