package org.aya.kala;

import com.intellij.openapi.util.Pair;
import kala.annotations.ReplaceWith;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@ReplaceWith("kala-collection-primitive")
public class Int2ObjectOpenHashMap<V> extends HashMap<Integer, V> {
  public void trim() {
  }

  public @NotNull List<Pair<Integer, V>> toList() {
    return this.entrySet().stream()
      .map(e -> new Pair<>(e.getKey(), e.getValue()))
      .collect(Collectors.toList());
  }

  @Override public Int2ObjectOpenHashMap<V> clone() {
    //noinspection unchecked
    return (Int2ObjectOpenHashMap<V>) super.clone();
  }
}
