/*
 * Decompiled with CFR 0.152.
 */
package org.aya.gradle;

public record JdkUrls(int javaVersion, String platform) {
    public static final String GARBAGE_SUFFIX = "-LTS";

    public String libericaJDK() {
        String libericaJdkVersion = System.getProperty("java.vm.version");
        if (libericaJdkVersion.endsWith(GARBAGE_SUFFIX)) {
            libericaJdkVersion = libericaJdkVersion.substring(0, libericaJdkVersion.length() - GARBAGE_SUFFIX.length());
        }
        String fixAmd64 = this.platform.replace("x64", "amd64");
        String suffix = this.platform.contains("linux") ? "tar.gz" : "zip";
        return "https://download.bell-sw.com/java/" + libericaJdkVersion + "/bellsoft-jdk" + libericaJdkVersion + "-" + fixAmd64 + "." + suffix;
    }

    public String riscv64JDK() {
        return "https://github.com/imkiva/openjdk-riscv-build/releases/download/bootstrap/openjdk-jdk" + this.javaVersion + "-" + this.platform + ".tar.gz";
    }

    public String jdk() {
        if (this.platform.contains("linux") && this.platform.contains("riscv")) {
            return this.riscv64JDK();
        }
        return this.libericaJDK();
    }
}

