/*
 * Decompiled with CFR 0.152.
 */
package org.aya.gradle;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public interface BuildUtil {
    public static final String OLD_EX = "java/lang/MatchException";
    public static final String NEW_EX = "java/lang/RuntimeException";
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int SIZE_INVALID = -114514;
    public static final int U1 = 1;
    public static final int U2 = 2;
    public static final int U4 = 4;
    public static final int[] POOL_ENTRY_SIZE = new int[]{-114514, 0, -114514, 4, 4, 8, 8, 2, 2, 4, 4, 4, 4, -114514, -114514, 3, 2, -114514, 4, 2, 2};

    public static String gitRev(File rootDir) throws IOException, InterruptedException {
        Process proc = new ProcessBuilder("git", "rev-parse", "HEAD").directory(rootDir).start();
        proc.waitFor(3L, TimeUnit.SECONDS);
        byte[] stdout = proc.getInputStream().readAllBytes();
        byte[] stderr = proc.getErrorStream().readAllBytes();
        if (stdout.length == 0) {
            throw new IOException(new String(stderr));
        }
        return new String(stdout).trim();
    }

    public static void stripPreview(Path root, Path classFile) throws IOException {
        BuildUtil.stripPreview(root, classFile, NEW_EX);
    }

    public static void stripPreview(Path root, Path classFile, String matchException) throws IOException {
        BuildUtil.stripPreview(root, classFile, true, true, matchException);
    }

    public static void stripPreview(Path root, Path classFile, boolean forceJava17, boolean verbose, String matchException) throws IOException {
        Path relative = root.relativize(classFile.toAbsolutePath());
        ByteBuffer mm = ByteBuffer.wrap(Files.readAllBytes(classFile));
        int magic = mm.getInt(0);
        if (magic != -889275714) {
            return;
        }
        FileTime time = Files.getLastModifiedTime(classFile, new LinkOption[0]);
        Path tmpFile = classFile.resolveSibling(String.valueOf(classFile.getFileName()) + ".tmp.class");
        try (RandomAccessFile raf = new RandomAccessFile(tmpFile.toFile(), "rw");){
            raf.writeInt(magic);
            int minor = mm.getShort(4) & 0xFFFF;
            if (minor == 65535) {
                BuildUtil.log(verbose, "AyaBuild[minor] %s: 0x%x -> 0", relative, minor);
                raf.writeShort(0);
            } else {
                raf.writeShort(minor);
            }
            int major = mm.getShort(6) & 0xFFFF;
            if (forceJava17 && major > 61) {
                BuildUtil.log(verbose, "AyaBuild[major] %s: %d (Java %d) -> 61 (Java 17)", relative, major, 17 + major - 61);
                raf.writeShort(61);
                int poolEnd = BuildUtil.replaceException(relative, verbose, mm, raf, matchException);
                raf.write(mm.array(), poolEnd, mm.capacity() - poolEnd);
            } else {
                raf.writeShort(major);
                raf.write(mm.array(), 8, mm.capacity() - 8);
            }
        }
        Files.move(tmpFile, classFile, StandardCopyOption.REPLACE_EXISTING);
        Files.setLastModifiedTime(classFile, time);
    }

    private static int replaceException(Path relative, boolean verbose, ByteBuffer mm, RandomAccessFile raf, String matchException) throws IOException {
        int poolCount = 8;
        int poolStart = 10;
        int cpCount = mm.getShort(8) & 0xFFFF;
        raf.writeShort(cpCount);
        int off = 10;
        for (int i = 1; i < cpCount; ++i) {
            int length;
            int tag = mm.get(off++) & 0xFF;
            raf.writeByte(tag);
            if (tag != 1) {
                if (tag == 0 || tag >= POOL_ENTRY_SIZE.length) {
                    throw new IllegalStateException("AyaBuild[cpool] %s: unexpected pool entry tag %d at pool index %d".formatted(relative, tag, i));
                }
                length = POOL_ENTRY_SIZE[tag];
                if (length == -114514) {
                    throw new IllegalStateException("AyaBuild[cpool] %s: unexpected pool entry length %d at pool index %d with tag %d".formatted(relative, length, i, tag));
                }
                raf.write(mm.array(), off, length);
                off += length;
                if (tag != 5 && tag != 6) continue;
                ++i;
                continue;
            }
            length = mm.getShort(off) & 0xFFFF;
            byte[] bytes = new byte[length];
            mm.get(off += 2, bytes);
            off += length;
            String string = new String(bytes, StandardCharsets.UTF_8);
            if (string.equals(OLD_EX)) {
                BuildUtil.log(verbose, "AyaBuild[cpool] %s: %s(%d) -> %s", relative, OLD_EX, i, matchException);
                raf.writeShort(matchException.length());
                raf.write(matchException.getBytes(StandardCharsets.UTF_8));
                continue;
            }
            raf.writeShort(length);
            raf.write(bytes);
        }
        return off;
    }

    private static void log(boolean verbose, String fmt, Object ... args) {
        if (verbose) {
            System.out.printf(fmt + "%n", args);
        }
    }
}

