package org.aya.gradle;

import java.io.*;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface CodegenUtil {
  /**
   * @param lexerG4Reader not closed
   */
  static Map<String, String> collectKeywords(
    String start, String end,
    BufferedReader lexerG4Reader
  ) {
    var keywords = new HashMap<String, String>();
    var inside = new Object() {
      boolean var = false;
    };
    lexerG4Reader.lines().forEach(line -> {
      line = line.trim();
      if (Objects.equals(line, start)) inside.var = true;
      else if (Objects.equals(line, end)) inside.var = false;
      else if (inside.var && !line.isEmpty() && !line.startsWith("//")) {
        var lineNoColon = line.substring(0, line.lastIndexOf(';'));
        var a = lineNoColon.split("[:=]", 2);
        var token = a[0].trim();
        var text = a[1].split("\\|")[0].trim();
        text = text.substring(1, text.length() - 1);
        keywords.put(token, text);
      }
    });
    return keywords;
  }
}
