package org.aya.gradle.jflex;

import jflex.core.OptionUtils;
import jflex.generator.LexGenerator;
import jflex.l10n.ErrorMessages;
import jflex.option.Options;
import jflex.skeleton.Skeleton;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public interface JFlexUtil {
  static void invokeJflex(File outputDir, File jflex, File rootDir) throws IOException {
    setupJflex(outputDir, rootDir);
    new LexGenerator(jflex).generate();
  }

  static void setupJflex(File outputDir, File rootDir) throws IOException {
    try (var stream = JFlexUtil.class.getResourceAsStream("/jflex/aya-flex.skeleton")) {
      assert stream != null;
      Skeleton.readSkel(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)));
    }
    Options.setRootDirectory(rootDir);
    Options.encoding = StandardCharsets.UTF_8;
    OptionUtils.setDir(outputDir);
    Options.no_minimize = false;
    Options.no_backup = true;
    Options.enable(ErrorMessages.MACRO_UNUSED);
    Options.enable(ErrorMessages.EMPTY_MATCH);
    Options.progress = false;
  }
}
