/*
 * Decompiled with CFR 0.152.
 */
package org.aya.producer.flcl;

import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.DefaultPsiParser;
import com.intellij.psi.TokenType;
import java.util.EnumMap;
import java.util.Map;
import kala.collection.SeqView;
import kala.collection.base.Growable;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableArrayList;
import org.aya.intellij.MarkerNodeWrapper;
import org.aya.parser.FlclLanguage;
import org.aya.parser.FlclParserDefinition;
import org.aya.parser.FlclPsiElementTypes;
import org.aya.producer.AyaProducer;
import org.aya.producer.ParserUtil;
import org.aya.producer.flcl.FlclToken;
import org.aya.util.error.SourceFile;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FlclParser(@NotNull Reporter reporter, @NotNull SourceFile file, @NotNull EnumMap<FlclToken.Type, ImmutableSeq<String>> decls) {
    public FlclParser(@NotNull Reporter reporter, @NotNull SourceFile file) {
        this(reporter, file, new EnumMap<FlclToken.Type, ImmutableSeq<String>>(FlclToken.Type.class));
    }

    @NotNull
    public FlclToken.File computeAst() {
        String text = this.file.sourceCode();
        MarkerNodeWrapper node = new MarkerNodeWrapper(text, new FlclFleetParser().parse(text));
        node.childrenOfType(FlclPsiElementTypes.RULE).forEach(rule -> {
            SeqView idChildren = rule.childrenOfType(FlclPsiElementTypes.ID).map(MarkerNodeWrapper::tokenText).map(CharSequence::toString);
            String title = (String)idChildren.getFirst();
            ImmutableSeq ids = idChildren.drop(1).toImmutableSeq();
            this.insert(title, (ImmutableSeq<String>)ids);
        });
        MarkerNodeWrapper body = (MarkerNodeWrapper)node.child(FlclPsiElementTypes.BODY);
        ImmutableSeq ids = body.childrenOfType(FlclPsiElementTypes.ID).toImmutableSeq();
        ImmutableSeq nums = body.childrenOfType(FlclPsiElementTypes.NUMBER).toImmutableSeq();
        ImmutableSeq ws = body.childrenOfType(TokenType.WHITE_SPACE).toImmutableSeq();
        MutableArrayList tokens = MutableArrayList.create((int)(ids.size() + nums.size() + ws.size()));
        ids.mapNotNullTo((Growable)tokens, this::computeType);
        nums.mapTo((Growable)tokens, n -> this.computeToken(n.range(), FlclToken.Type.Number));
        ws.mapTo((Growable)tokens, n -> this.computeToken(n.range(), n.tokenText().indexOf('\n') > 0 ? FlclToken.Type.Eol : FlclToken.Type.WhiteSpace));
        int startIndex = ((MarkerNodeWrapper)node.child(FlclPsiElementTypes.SEPARATOR)).range().getEndOffset() + 1;
        return new FlclToken.File((ImmutableSeq<FlclToken>)tokens.toImmutableSeq(), body.tokenText(), startIndex);
    }

    private void insert(String title, @NotNull ImmutableSeq<String> ids) {
        for (FlclToken.Type tokenType : FlclToken.Type.values()) {
            if (!tokenType.name().equalsIgnoreCase(title)) continue;
            this.decls.put(tokenType, ids);
            return;
        }
        this.reporter.reportString("Unknown rule: " + title, Problem.Severity.WARN);
    }

    @Nullable
    private FlclToken computeType(@NotNull MarkerNodeWrapper text) {
        for (Map.Entry<FlclToken.Type, ImmutableSeq<String>> entry : this.decls.entrySet()) {
            if (!entry.getValue().contains((Object)text.tokenText().toString())) continue;
            return this.computeToken(text.range(), entry.getKey());
        }
        return null;
    }

    @NotNull
    private FlclToken computeToken(TextRange range, FlclToken.Type key) {
        return new FlclToken(AyaProducer.sourcePosOf(range, this.file, true), key);
    }

    private static class FlclFleetParser
    extends DefaultPsiParser {
        public FlclFleetParser() {
            super((ParserDefinition)new FlclParserDefinition(ParserUtil.forLanguage((Language)FlclLanguage.INSTANCE)));
        }
    }
}

