/*
 * Decompiled with CFR 0.152.
 */
package org.aya.producer;

import com.intellij.psi.tree.IElementType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Predicate;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import org.aya.generic.Modifier;
import org.aya.parser.AyaPsiElementTypes;
import org.aya.producer.error.ModifierProblem;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ModifierParser(@NotNull Reporter reporter) {
    public static final Filter DECL_FILTER = Filter.create((WithPos<Stmt.Accessibility>)new WithPos(SourcePos.NONE, (Object)Stmt.Accessibility.Public), EnumSet.of(CModifier.Open, CModifier.Example));
    public static final Filter FN_FILTER = Filter.create((WithPos<Stmt.Accessibility>)new WithPos(SourcePos.NONE, (Object)Stmt.Accessibility.Public), EnumSet.of(CModifier.Opaque, CModifier.Inline, CModifier.Overlap, CModifier.Partial, CModifier.Example));
    public static final Filter SUBDECL_FILTER = Filter.create((WithPos<Stmt.Accessibility>)new WithPos(SourcePos.NONE, (Object)Stmt.Accessibility.Public), EnumSet.noneOf(CModifier.class)).and(cModifier -> false);

    @NotNull
    private ImmutableSeq<WithPos<CModifier>> implication(@NotNull ImmutableSeq<WithPos<CModifier>> modifiers) {
        return ((ImmutableMap)modifiers.view().flatMap(modi -> Seq.from((Object[])((CModifier)((Object)((Object)modi.data()))).implies).map(imply -> new WithPos(modi.sourcePos(), (Object)imply))).collect(ImmutableMap.collector(WithPos::data, x -> x))).valuesView().toImmutableSeq();
    }

    @NotNull
    public Modifiers parse(@NotNull ImmutableSeq<WithPos<CModifier>> modifiers, @NotNull Filter filter) {
        EnumMap<ModifierGroup, EnumMap> map = new EnumMap<ModifierGroup, EnumMap>(ModifierGroup.class);
        modifiers = this.implication(modifiers).concat(modifiers);
        for (WithPos data : modifiers) {
            SourcePos pos = data.sourcePos();
            CModifier modifier = (CModifier)((Object)data.data());
            if (!filter.available.test((CModifier)((Object)data.data()))) {
                this.reportUnsuitableModifier((WithPos<CModifier>)data);
                continue;
            }
            map.computeIfAbsent(modifier.group, modifierGroup -> new EnumMap(CModifier.class));
            EnumMap exists = (EnumMap)map.get((Object)modifier.group);
            if (exists.containsKey((Object)modifier)) {
                this.reportDuplicatedModifier((WithPos<CModifier>)data);
                continue;
            }
            if (modifier.group != ModifierGroup.None && !exists.isEmpty() && !exists.containsKey((Object)modifier)) {
                assert (exists.size() == 1);
                Map.Entry contradict = (Map.Entry)Seq.from(exists.entrySet()).getFirst();
                this.reportContradictModifier((WithPos<CModifier>)data, (WithPos<CModifier>)new WithPos((SourcePos)contradict.getValue(), (Object)((CModifier)((Object)contradict.getKey()))));
                continue;
            }
            exists.put(modifier, pos);
        }
        return new ModifierSet((ImmutableMap<CModifier, SourcePos>)ImmutableMap.from((Iterable)ImmutableSeq.from(map.values()).flatMap(EnumMap::entrySet)), filter.defaultMods);
    }

    public void reportUnsuitableModifier(@NotNull WithPos<CModifier> data) {
        this.reporter.report((Problem)new ModifierProblem(data.sourcePos(), (CModifier)((Object)data.data()), ModifierProblem.Reason.Inappropriate));
    }

    public void reportDuplicatedModifier(@NotNull WithPos<CModifier> data) {
        this.reporter.report((Problem)new ModifierProblem(data.sourcePos(), (CModifier)((Object)data.data()), ModifierProblem.Reason.Duplicative));
    }

    public void reportContradictModifier(@NotNull WithPos<CModifier> current, @NotNull WithPos<CModifier> that) {
        this.reporter.report((Problem)new ModifierProblem(current.sourcePos(), (CModifier)((Object)current.data()), ModifierProblem.Reason.Contradictory));
    }

    public static enum ModifierGroup {
        None,
        Accessibility,
        Alpha;

    }

    public static enum CModifier {
        Private(AyaPsiElementTypes.KW_PRIVATE, ModifierGroup.Accessibility, "private", new CModifier[0]),
        Open(AyaPsiElementTypes.KW_OPEN, ModifierGroup.None, "open", new CModifier[0]),
        Example(AyaPsiElementTypes.KW_EXAMPLE, ModifierGroup.None, "example", new CModifier[0]),
        Opaque(AyaPsiElementTypes.KW_OPAQUE, ModifierGroup.Alpha, "opaque", new CModifier[0]),
        Inline(AyaPsiElementTypes.KW_INLINE, ModifierGroup.Alpha, "inline", new CModifier[0]),
        Partial(AyaPsiElementTypes.KW_PARTIAL, ModifierGroup.None, "partial", Opaque),
        Overlap(AyaPsiElementTypes.KW_OVERLAP, ModifierGroup.None, "overlap", new CModifier[0]);

        @NotNull
        public final IElementType type;
        @NotNull
        public final ModifierGroup group;
        @NotNull
        public final String keyword;
        @NotNull
        public final CModifier[] implies;

        private CModifier(@NotNull IElementType type, @NotNull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotNull @NotNull ModifierGroup group, String keyword, CModifier ... implies) {
            this.type = type;
            this.group = group;
            this.keyword = keyword;
            this.implies = implies;
        }
    }

    public record Filter(@NotNull Modifiers defaultMods, @NotNull Predicate<CModifier> available) {
        @NotNull
        public Filter and(@NotNull Predicate<CModifier> and) {
            return new Filter(this.defaultMods, this.available.and(and));
        }

        @NotNull
        public static Filter create(@NotNull WithPos<Stmt.Accessibility> defaultAcc, @NotNull EnumSet<CModifier> miscAvail) {
            return new Filter(new DefaultModifiers(defaultAcc, miscAvail), mod -> switch (mod.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1, 2, 3, 4, 5, 6 -> miscAvail.contains(mod);
            });
        }
    }

    private record ModifierSet(@NotNull ImmutableMap<CModifier, SourcePos> mods, @NotNull Modifiers parent) implements Modifiers
    {
        @Override
        @Contract(pure=true)
        @NotNull
        public WithPos<Stmt.Accessibility> accessibility() {
            return (WithPos)this.mods.getOption((Object)CModifier.Private).map(pos -> new WithPos(pos, (Object)Stmt.Accessibility.Private)).getOrElse(this.parent::accessibility);
        }

        @Override
        public boolean isExample() {
            return this.mods.containsKey((Object)CModifier.Example) || this.parent.isExample();
        }

        @Override
        @Nullable
        public SourcePos misc(@NotNull CModifier key) {
            return (SourcePos)this.mods.getOrElse((Object)key, () -> this.parent.misc(key));
        }
    }

    public static interface Modifiers {
        @Contract(pure=true)
        @NotNull
        public WithPos<Stmt.Accessibility> accessibility();

        @Contract(pure=true)
        public boolean isExample();

        @Contract(pure=true)
        @Nullable
        public SourcePos misc(@NotNull CModifier var1);

        @NotNull
        default public EnumSet<Modifier> toFnModifiers() {
            EnumSet<Modifier> fnMods = EnumSet.noneOf(Modifier.class);
            if (this.misc(CModifier.Inline) != null) {
                fnMods.add(Modifier.Inline);
            }
            if (this.misc(CModifier.Opaque) != null) {
                fnMods.add(Modifier.Opaque);
            }
            if (this.misc(CModifier.Overlap) != null) {
                fnMods.add(Modifier.Overlap);
            }
            if (this.misc(CModifier.Partial) != null) {
                fnMods.add(Modifier.Partial);
            }
            return fnMods;
        }
    }

    record DefaultModifiers(@NotNull WithPos<Stmt.Accessibility> accessibility, @NotNull EnumSet<CModifier> miscAvail) implements Modifiers
    {
        @Override
        public boolean isExample() {
            return false;
        }

        @Override
        @Nullable
        public SourcePos misc(@NotNull CModifier key) {
            return null;
        }
    }
}

