/*
 * Decompiled with CFR 0.152.
 */
package org.aya.producer;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import java.util.stream.Collectors;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableSinglyLinkedList;
import kala.control.Either;
import kala.control.Option;
import kala.function.BooleanObjBiFunction;
import kala.text.StringSlice;
import kala.value.MutableValue;
import org.aya.generic.Constants;
import org.aya.generic.Modifier;
import org.aya.generic.term.SortKind;
import org.aya.intellij.GenericNode;
import org.aya.parser.AyaPsiElementTypes;
import org.aya.parser.AyaPsiParser;
import org.aya.parser.AyaPsiTokenType;
import org.aya.producer.ModifierParser;
import org.aya.producer.ParsingInterruptedException;
import org.aya.producer.error.BadModifierWarn;
import org.aya.producer.error.ModifierProblem;
import org.aya.producer.error.ParseError;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.concrete.stmt.BindBlock;
import org.aya.syntax.concrete.stmt.Command;
import org.aya.syntax.concrete.stmt.Generalize;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.UseHide;
import org.aya.syntax.concrete.stmt.decl.ClassDecl;
import org.aya.syntax.concrete.stmt.decl.ClassMember;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.concrete.stmt.decl.DataDecl;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.concrete.stmt.decl.DeclInfo;
import org.aya.syntax.concrete.stmt.decl.FnBody;
import org.aya.syntax.concrete.stmt.decl.FnDecl;
import org.aya.syntax.concrete.stmt.decl.PrimDecl;
import org.aya.syntax.ref.GeneralizedVar;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.Arg;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.Panic;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AyaProducer(@NotNull Either<SourceFile, SourcePos> source, @NotNull Reporter reporter) {
    @NotNull
    public static final TokenSet ARRAY_BLOCK = AyaPsiParser.EXTENDS_SETS_[0];
    @NotNull
    public static final TokenSet ARGUMENT = AyaPsiParser.EXTENDS_SETS_[2];
    @NotNull
    public static final TokenSet STMT = AyaPsiParser.EXTENDS_SETS_[3];
    @NotNull
    public static final TokenSet EXPR = AyaPsiParser.EXTENDS_SETS_[4];
    @NotNull
    public static final TokenSet DECL = TokenSet.create((IElementType[])new IElementType[]{AyaPsiElementTypes.DATA_DECL, AyaPsiElementTypes.FN_DECL, AyaPsiElementTypes.PRIM_DECL, AyaPsiElementTypes.CLASS_DECL});

    @NotNull
    public Either<ImmutableSeq<Stmt>, WithPos<Expr>> program(@NotNull GenericNode<?> node) {
        GenericNode repl = node.peekChild(EXPR);
        if (repl != null) {
            return Either.right(this.expr(repl));
        }
        return Either.left((Object)node.childrenOfType(STMT).flatMap(this::stmt).toImmutableSeq());
    }

    @NotNull
    public ImmutableSeq<Stmt> stmt(@NotNull GenericNode<?> node) {
        if (node.is(AyaPsiElementTypes.IMPORT_CMD)) {
            return ImmutableSeq.of((Object)this.importCmd(node));
        }
        if (node.is(AyaPsiElementTypes.MODULE)) {
            return ImmutableSeq.of((Object)this.module(node));
        }
        if (node.is(AyaPsiElementTypes.OPEN_CMD)) {
            return this.openCmd(node);
        }
        if (node.is(DECL)) {
            MutableList stmts = MutableList.create();
            Decl result = this.decl(node, (MutableList<Stmt>)stmts);
            if (result != null) {
                stmts.prepend((Object)result);
            }
            return stmts.toImmutableSeq();
        }
        if (node.is(AyaPsiElementTypes.GENERALIZE)) {
            return ImmutableSeq.of((Object)this.generalize(node));
        }
        return (ImmutableSeq)this.unreachable(node);
    }

    @NotNull
    public Generalize generalize(@NotNull GenericNode<?> node) {
        return new Generalize(this.sourcePosOf(node), node.childrenOfType(AyaPsiElementTypes.GENERALIZE_PARAM_NAME).map(this::generalizeParamName).map(id -> new GeneralizedVar((String)id.data(), id.sourcePos())).toImmutableSeq(), this.type(node.child(AyaPsiElementTypes.TYPE)));
    }

    @NotNull
    public Command.Import importCmd(@NotNull GenericNode<?> node) {
        GenericNode acc = node.peekChild(AyaPsiElementTypes.KW_PUBLIC);
        GenericNode asId = node.peekChild(AyaPsiElementTypes.WEAK_ID);
        GenericNode importMod = node.child(AyaPsiElementTypes.QUALIFIED_ID);
        return new Command.Import(this.sourcePosOf(importMod), this.modulePath(importMod), asId == null ? null : (String)this.weakId(asId).data(), acc == null ? Stmt.Accessibility.Private : Stmt.Accessibility.Public);
    }

    @NotNull
    public ImmutableSeq<Stmt> openCmd(@NotNull GenericNode<?> node) {
        Stmt.Accessibility accessibility = node.peekChild(AyaPsiElementTypes.KW_PUBLIC) == null ? Stmt.Accessibility.Private : Stmt.Accessibility.Public;
        GenericNode useHide = node.peekChild(AyaPsiElementTypes.USE_HIDE);
        GenericNode modNameNode = node.child(AyaPsiElementTypes.QUALIFIED_ID);
        SourcePos namePos = this.sourcePosOf(modNameNode);
        ModulePath modName = this.modulePath(modNameNode);
        boolean openImport = node.peekChild(AyaPsiElementTypes.KW_IMPORT) != null;
        Command.Open open = new Command.Open(namePos, accessibility, modName.asName(), useHide != null ? this.useHide(useHide) : UseHide.EMPTY, false, openImport);
        return openImport ? ImmutableSeq.of((Object)new Command.Import(namePos, modName, null, accessibility), (Object)open) : ImmutableSeq.of((Object)open);
    }

    public UseHide hideList(SeqView<? extends GenericNode<?>> hideLists, UseHide.Strategy strategy) {
        return new UseHide(hideLists.mapNotNull(h -> h.peekChild(AyaPsiElementTypes.COMMA_SEP)).flatMap(node -> node.childrenOfType(AyaPsiElementTypes.QUALIFIED_ID).map(this::qualifiedId)).map(UseHide.Name::new).toImmutableSeq(), strategy);
    }

    public UseHide useList(SeqView<? extends GenericNode<?>> useLists, UseHide.Strategy strategy) {
        return new UseHide(useLists.mapNotNull(u -> u.peekChild(AyaPsiElementTypes.COMMA_SEP)).flatMap(this::useIdsComma).toImmutableSeq(), strategy);
    }

    public SeqView<UseHide.Name> useIdsComma(@NotNull GenericNode<?> node) {
        return node.childrenOfType(AyaPsiElementTypes.USE_ID).map(id -> {
            SourcePos wholePos = this.sourcePosOf((GenericNode<?>)id);
            QualifiedID name = this.qualifiedId(id.child(AyaPsiElementTypes.QUALIFIED_ID));
            GenericNode useAs = id.peekChild(AyaPsiElementTypes.USE_AS);
            if (useAs == null) {
                return new UseHide.Name(name);
            }
            String asId = (String)this.weakId(useAs.child(AyaPsiElementTypes.WEAK_ID)).data();
            GenericNode asAssoc = useAs.peekChild(AyaPsiElementTypes.ASSOC);
            GenericNode asBind = useAs.peekChild(AyaPsiElementTypes.BIND_BLOCK);
            return new UseHide.Name(wholePos, name, Option.some((Object)asId), asAssoc != null ? this.assoc(asAssoc) : Assoc.Invalid, asBind != null ? this.bindBlock(asBind) : BindBlock.EMPTY);
        });
    }

    @NotNull
    public Assoc assoc(@NotNull GenericNode<?> node) {
        if (node.peekChild(AyaPsiElementTypes.KW_INFIX) != null) {
            return Assoc.Infix;
        }
        if (node.peekChild(AyaPsiElementTypes.KW_INFIXL) != null) {
            return Assoc.InfixL;
        }
        if (node.peekChild(AyaPsiElementTypes.KW_INFIXR) != null) {
            return Assoc.InfixR;
        }
        if (node.peekChild(AyaPsiElementTypes.KW_FIXL) != null) {
            return Assoc.FixL;
        }
        if (node.peekChild(AyaPsiElementTypes.KW_FIXR) != null) {
            return Assoc.FixR;
        }
        return (Assoc)this.unreachable(node);
    }

    @NotNull
    public BindBlock bindBlock(@NotNull GenericNode<?> node) {
        return new BindBlock(this.sourcePosOf(node), node.childrenOfType(AyaPsiElementTypes.LOOSERS).flatMap(this::qualifiedIDs).toImmutableSeq(), node.childrenOfType(AyaPsiElementTypes.TIGHTERS).flatMap(this::qualifiedIDs).toImmutableSeq(), MutableValue.create(), MutableValue.create());
    }

    @NotNull
    private SeqView<QualifiedID> qualifiedIDs(GenericNode<?> c) {
        return c.childrenOfType(AyaPsiElementTypes.QUALIFIED_ID).map(this::qualifiedId);
    }

    @NotNull
    public UseHide useHide(@NotNull GenericNode<?> node) {
        if (node.peekChild(AyaPsiElementTypes.KW_HIDING) != null) {
            return this.hideList(node.childrenOfType(AyaPsiElementTypes.HIDE_LIST), UseHide.Strategy.Hiding);
        }
        if (node.peekChild(AyaPsiElementTypes.KW_USING) != null) {
            return this.useList(node.childrenOfType(AyaPsiElementTypes.USE_LIST), UseHide.Strategy.Using);
        }
        return (UseHide)this.unreachable(node);
    }

    @NotNull
    public Command.Module module(@NotNull GenericNode<?> node) {
        WithPos<String> modName = this.weakId(node.child(AyaPsiElementTypes.WEAK_ID));
        return new Command.Module(modName.sourcePos(), this.sourcePosOf(node), (String)modName.data(), node.childrenOfType(STMT).flatMap(this::stmt).toImmutableSeq());
    }

    @Nullable
    public Decl decl(@NotNull GenericNode<?> node, @NotNull MutableList<Stmt> additional) {
        if (node.is(AyaPsiElementTypes.FN_DECL)) {
            return this.fnDecl(node);
        }
        if (node.is(AyaPsiElementTypes.PRIM_DECL)) {
            return this.primDecl(node);
        }
        if (node.is(AyaPsiElementTypes.DATA_DECL)) {
            return this.dataDecl(node, additional);
        }
        if (node.is(AyaPsiElementTypes.CLASS_DECL)) {
            return this.classDecl(node, additional);
        }
        return (Decl)this.unreachable(node);
    }

    @NotNull
    public ModifierParser.Modifiers declModifiersOf(@NotNull GenericNode<?> node, @NotNull ModifierParser.Filter filter) {
        SeqView modifiers = node.childrenOfType(AyaPsiElementTypes.DECL_MODIFIER).map(x -> {
            SourcePos pos = this.sourcePosOf((GenericNode<?>)x);
            ModifierParser.CModifier modifier = null;
            for (ModifierParser.CModifier mod : ModifierParser.CModifier.values()) {
                if (x.peekChild(mod.type) == null) continue;
                modifier = mod;
            }
            if (modifier == null) {
                this.unreachable((GenericNode<?>)x);
            }
            return new WithPos(pos, modifier);
        });
        return new ModifierParser(this.reporter()).parse((ImmutableSeq<WithPos<ModifierParser.CModifier>>)modifiers.toImmutableSeq(), filter);
    }

    @NotNull
    private DeclParseData declInfo(@NotNull GenericNode<?> node, @NotNull ModifierParser.Filter filter) {
        ModifierParser.Modifiers modifier = this.declModifiersOf(node, filter);
        GenericNode bind = node.peekChild(AyaPsiElementTypes.BIND_BLOCK);
        Option nameOrInfix = Option.ofNullable((Object)this.declNameOrInfix(node.peekChild(AyaPsiElementTypes.DECL_NAME_OR_INFIX)));
        SourcePos wholePos = this.sourcePosOf(node);
        DeclInfo info = new DeclInfo((Stmt.Accessibility)modifier.accessibility().data(), (SourcePos)nameOrInfix.map(x -> x.name.sourcePos()).getOrDefault((Object)SourcePos.NONE), wholePos, (OpDecl.OpInfo)nameOrInfix.map(DeclNameOrInfix::infix).getOrNull(), bind == null ? BindBlock.EMPTY : this.bindBlock(bind));
        return new DeclParseData(node, info, (String)nameOrInfix.map(x -> (String)x.name.data()).getOrNull(), modifier);
    }

    @Nullable
    public FnDecl fnDecl(@NotNull GenericNode<?> node) {
        DeclParseData info = this.declInfo(node, ModifierParser.FN_FILTER);
        String name = info.checkName(this);
        if (name == null) {
            return null;
        }
        GenericNode fnBodyNode = node.peekChild(AyaPsiElementTypes.FN_BODY);
        if (fnBodyNode == null) {
            return (FnDecl)this.error((GenericNode)node.childrenView().getFirst(), "Expect a function body");
        }
        EnumSet<Modifier> fnMods = info.modifier().toFnModifiers();
        ImmutableSeq<Expr.Param> tele = this.telescope(node.childrenOfType(AyaPsiElementTypes.TELE));
        FnBody dynamite = this.fnBody((ImmutableSeq<LocalVar>)tele.map(Expr.Param::ref), fnBodyNode);
        if (dynamite == null) {
            return null;
        }
        SourcePos inline = info.modifier.misc(ModifierParser.CModifier.Inline);
        SourcePos overlap = info.modifier.misc(ModifierParser.CModifier.Overlap);
        if (dynamite instanceof FnBody.BlockBody && inline != null) {
            this.reporter.report((Problem)new BadModifierWarn(inline, Modifier.Inline));
        }
        if (dynamite instanceof FnBody.ExprBody && overlap != null) {
            this.reporter.report((Problem)new ModifierProblem(overlap, ModifierParser.CModifier.Overlap, ModifierProblem.Reason.Duplicative));
        }
        WithPos<Expr> ty = this.typeOrNull(node.peekChild(AyaPsiElementTypes.TYPE));
        FnDecl fnDecl = new FnDecl(info.info, fnMods, name, tele, ty, dynamite);
        if (info.modifier.isExample()) {
            fnDecl.isExample = true;
        }
        return fnDecl;
    }

    @Nullable
    public FnBody fnBody(@NotNull ImmutableSeq<LocalVar> vars, @NotNull GenericNode<?> node) {
        GenericNode expr = node.peekChild(EXPR);
        GenericNode implies = node.peekChild(AyaPsiElementTypes.IMPLIES);
        if (expr == null && implies != null) {
            return (FnBody)this.error(implies, "Expect function body");
        }
        if (expr != null) {
            return new FnBody.ExprBody(this.expr(expr));
        }
        ImmutableSeq body = node.childrenOfType(AyaPsiElementTypes.BARRED_CLAUSE).map(this::bareOrBarredClause).toImmutableSeq();
        ImmutableSeq elims = node.childrenOfType(AyaPsiElementTypes.WEAK_ID).map(this::weakId).toImmutableSeq();
        return new FnBody.BlockBody(body, null, elims);
    }

    private void giveMeOpen(@NotNull ModifierParser.Modifiers modiSet, @NotNull Decl decl, @NotNull MutableList<Stmt> additional) {
        SourcePos keyword = modiSet.misc(ModifierParser.CModifier.Open);
        if (keyword == null) {
            return;
        }
        additional.append((Object)new Command.Open(keyword, (Stmt.Accessibility)modiSet.accessibility().data(), new ModuleName.Qualified(new String[]{decl.ref().name()}), UseHide.EMPTY, modiSet.isExample(), true));
    }

    @Nullable
    public DataDecl dataDecl(GenericNode<?> node, @NotNull MutableList<Stmt> additional) {
        ImmutableSeq body = node.childrenOfType(AyaPsiElementTypes.DATA_BODY).mapNotNull(this::dataBody).toImmutableSeq();
        ImmutableSeq<Expr.Param> tele = this.telescope(node.childrenOfType(AyaPsiElementTypes.TELE));
        DeclParseData info = this.declInfo(node, ModifierParser.DECL_FILTER);
        String name = info.checkName(this);
        if (name == null) {
            return null;
        }
        WithPos<Expr> ty = this.typeOrNull(node.peekChild(AyaPsiElementTypes.TYPE));
        DataDecl decl = new DataDecl(info.info, name, tele, ty, body);
        if (info.modifier.isExample()) {
            decl.isExample = true;
        }
        this.giveMeOpen(info.modifier, (Decl)decl, additional);
        return decl;
    }

    @Nullable
    public DataCon dataBody(@NotNull GenericNode<?> node) {
        GenericNode dataConClause = node.peekChild(AyaPsiElementTypes.DATA_CON_CLAUSE);
        if (dataConClause != null) {
            return this.dataCon(this.patterns(dataConClause.child(AyaPsiElementTypes.PATTERNS).child(AyaPsiElementTypes.COMMA_SEP)), dataConClause.child(AyaPsiElementTypes.DATA_CON));
        }
        GenericNode dataCon = node.peekChild(AyaPsiElementTypes.DATA_CON);
        if (dataCon != null) {
            return this.dataCon((ImmutableSeq<Arg<WithPos<Pattern>>>)ImmutableSeq.empty(), dataCon);
        }
        return (DataCon)this.error((GenericNode)node.childrenView().getFirst(), "Expect a data constructor");
    }

    @Nullable
    public ClassDecl classDecl(@NotNull GenericNode<?> node, @NotNull MutableList<Stmt> additional) {
        DeclParseData info = this.declInfo(node, ModifierParser.DECL_FILTER);
        String name = info.checkName(this);
        if (name == null) {
            return null;
        }
        ImmutableSeq members = node.childrenOfType(AyaPsiElementTypes.CLASS_MEMBER).mapIndexed(this::classMember).toImmutableSeq();
        ClassDecl decl = new ClassDecl(name, info.info, members);
        this.giveMeOpen(info.modifier, (Decl)decl, additional);
        return decl;
    }

    @NotNull
    public ClassMember classMember(int index, GenericNode<?> node) {
        DeclParseData info = this.declInfo(node, ModifierParser.SUBDECL_FILTER);
        String name = info.checkName(this);
        if (name == null) {
            return (ClassMember)this.unreachable(node);
        }
        return new ClassMember(name, info.info, this.telescope(node.childrenOfType(AyaPsiElementTypes.TELE)), this.typeOrHole(node.peekChild(AyaPsiElementTypes.TYPE), info.info.sourcePos()));
    }

    @Nullable
    private <T> T error(@NotNull GenericNode<?> node, @NotNull String message) {
        this.reporter.report((Problem)new ParseError(this.sourcePosOf(node), message));
        return null;
    }

    @Nullable
    public PrimDecl primDecl(@NotNull GenericNode<?> node) {
        GenericNode nameEl = node.peekChild(AyaPsiElementTypes.PRIM_NAME);
        if (nameEl == null) {
            return (PrimDecl)this.error((GenericNode)node.childrenView().getFirst(), "Expect a primitive's name");
        }
        WithPos<String> id = this.weakId(nameEl.child(AyaPsiElementTypes.WEAK_ID));
        return new PrimDecl(id.sourcePos(), this.sourcePosOf(node), (String)id.data(), this.telescope(node.childrenOfType(AyaPsiElementTypes.TELE)), this.typeOrNull(node.peekChild(AyaPsiElementTypes.TYPE)));
    }

    @Nullable
    public DataCon dataCon(@NotNull ImmutableSeq<Arg<WithPos<Pattern>>> patterns, @NotNull GenericNode<?> node) {
        DeclParseData info = this.declInfo(node, ModifierParser.SUBDECL_FILTER);
        String name = info.checkName(this);
        if (name == null) {
            return null;
        }
        ImmutableSeq<Expr.Param> tele = this.telescope(node.childrenOfType(AyaPsiElementTypes.TELE));
        GenericNode ty = node.peekChild(AyaPsiElementTypes.TYPE);
        boolean coe = node.peekChild(AyaPsiElementTypes.KW_COERCE) != null;
        return new DataCon(info.info, name, patterns, tele, coe, ty == null ? null : this.type(ty));
    }

    @NotNull
    public ImmutableSeq<Expr.Param> telescope(SeqView<? extends GenericNode<?>> telescope) {
        return telescope.flatMap(this::tele).toImmutableSeq();
    }

    @NotNull
    public ImmutableSeq<Expr.Param> tele(@NotNull GenericNode<?> node) {
        GenericNode tele = node.peekChild(AyaPsiElementTypes.LICIT);
        if (tele != null) {
            return (ImmutableSeq)this.licit(tele, AyaPsiElementTypes.TELE_BINDER, this::teleBinder);
        }
        WithPos<Expr> type = this.expr(node.child(EXPR));
        SourcePos pos = this.sourcePosOf(node);
        return ImmutableSeq.of((Object)new Expr.Param(pos, Constants.randomlyNamed((SourcePos)pos), type, true));
    }

    @NotNull
    public ImmutableSeq<Expr.Param> teleBinder(boolean explicit, @NotNull GenericNode<?> node) {
        SourcePos pos = this.sourcePosOf(node);
        GenericNode typed = node.peekChild(AyaPsiElementTypes.TELE_BINDER_TYPED);
        if (typed != null) {
            return this.teleBinderTyped(typed, explicit);
        }
        GenericNode anonymous = node.peekChild(AyaPsiElementTypes.TELE_BINDER_ANONYMOUS);
        if (anonymous != null) {
            return ImmutableSeq.of((Object)new Expr.Param(pos, Constants.randomlyNamed((SourcePos)pos), this.expr(anonymous.child(EXPR)), explicit));
        }
        return (ImmutableSeq)this.unreachable(node);
    }

    @NotNull
    private ImmutableSeq<Expr.Param> teleBinderTyped(@NotNull GenericNode<?> node, boolean explicit) {
        ImmutableSeq<WithPos<String>> ids = this.teleBinderUntyped(node.child(AyaPsiElementTypes.TELE_BINDER_UNTYPED));
        WithPos<Expr> type = this.type(node.child(AyaPsiElementTypes.TYPE));
        return ids.map(i -> new Expr.Param(i.sourcePos(), LocalVar.from((WithPos)i), type, explicit));
    }

    @NotNull
    private ImmutableSeq<WithPos<String>> teleBinderUntyped(@NotNull GenericNode<?> node) {
        return node.childrenOfType(AyaPsiElementTypes.TELE_PARAM_NAME).map(this::teleParamName).toImmutableSeq();
    }

    @NotNull
    public ImmutableSeq<Expr.Param> lambdaTelescope(SeqView<? extends GenericNode<?>> telescope) {
        return telescope.flatMap(this::lambdaTele).toImmutableSeq();
    }

    @NotNull
    public ImmutableSeq<Expr.Param> lambdaTele(@NotNull GenericNode<?> node) {
        GenericNode teleParamName = node.peekChild(AyaPsiElementTypes.TELE_PARAM_NAME);
        if (teleParamName != null) {
            return this.lambdaTeleLit(teleParamName, this.sourcePosOf(node));
        }
        return (ImmutableSeq)this.licit(node.child(AyaPsiElementTypes.LICIT), AyaPsiElementTypes.LAMBDA_TELE_BINDER, this::lambdaTeleBinder);
    }

    @NotNull
    private <T> T licit(@NotNull GenericNode<?> node, @NotNull IElementType type, @NotNull LicitParser<T> parser) {
        GenericNode child = node.child(type);
        return (T)parser.apply(node.peekChild(AyaPsiElementTypes.LBRACE) == null, child);
    }

    @NotNull
    public ImmutableSeq<Expr.Param> lambdaTeleBinder(boolean explicit, @NotNull GenericNode<?> node) {
        GenericNode typed = node.peekChild(AyaPsiElementTypes.TELE_BINDER_TYPED);
        if (typed != null) {
            return this.teleBinderTyped(typed, explicit);
        }
        SourcePos pos = this.sourcePosOf(node);
        GenericNode ids = node.child(AyaPsiElementTypes.TELE_BINDER_UNTYPED);
        return this.teleBinderUntyped(ids).view().map(LocalVar::from).map(bind -> new Expr.Param(bind.definition(), bind, this.typeOrHole(null, pos), explicit)).toImmutableSeq();
    }

    @NotNull
    private ImmutableSeq<Expr.Param> lambdaTeleLit(GenericNode<?> node, SourcePos pos) {
        return ImmutableSeq.of((Object)new Expr.Param(pos, LocalVar.from(this.teleParamName(node)), this.typeOrHole(null, pos), true));
    }

    @Nullable
    private DeclNameOrInfix declNameOrInfix(@Nullable GenericNode<?> node) {
        if (node == null) {
            return null;
        }
        GenericNode assoc = node.peekChild(AyaPsiElementTypes.ASSOC);
        WithPos<String> id = this.weakId(node.child(AyaPsiElementTypes.WEAK_ID));
        if (assoc == null) {
            return new DeclNameOrInfix(id, null);
        }
        OpDecl.OpInfo infix = new OpDecl.OpInfo((String)id.data(), this.assoc(assoc));
        return new DeclNameOrInfix((WithPos<String>)new WithPos(id.sourcePos(), (Object)infix.name()), infix);
    }

    @NotNull
    public WithPos<Expr> expr(@NotNull GenericNode<?> node) {
        SourcePos pos = this.sourcePosOf(node);
        if (node.is(AyaPsiElementTypes.REF_EXPR)) {
            QualifiedID qid = this.qualifiedId(node.child(AyaPsiElementTypes.QUALIFIED_ID));
            return new WithPos(pos, (Object)new Expr.Unresolved(qid));
        }
        if (node.is(AyaPsiElementTypes.CALM_FACE_EXPR)) {
            return new WithPos(pos, (Object)new Expr.Hole(false, null));
        }
        if (node.is(AyaPsiElementTypes.GOAL_EXPR)) {
            GenericNode fillingExpr = node.peekChild(EXPR);
            WithPos<Expr> filling = fillingExpr == null ? null : this.expr(fillingExpr);
            return new WithPos(pos, (Object)new Expr.Hole(true, filling));
        }
        if (node.is(AyaPsiElementTypes.UNIV_EXPR)) {
            if (node.peekChild(AyaPsiElementTypes.KW_TYPE) != null) {
                return new WithPos(pos, (Object)new Expr.RawSort(SortKind.Type));
            }
            if (node.peekChild(AyaPsiElementTypes.KW_SET) != null) {
                return new WithPos(pos, (Object)new Expr.RawSort(SortKind.Set));
            }
            if (node.peekChild(AyaPsiElementTypes.KW_ISET) != null) {
                return new WithPos(pos, (Object)new Expr.RawSort(SortKind.ISet));
            }
            return (WithPos)this.unreachable(node);
        }
        if (node.is(AyaPsiElementTypes.LIT_INT_EXPR)) {
            try {
                return new WithPos(pos, (Object)new Expr.LitInt(node.tokenText().toInt()));
            }
            catch (NumberFormatException ignored) {
                this.reporter.report((Problem)new ParseError(pos, "Unsupported integer literal `" + String.valueOf(node.tokenText()) + "`"));
                throw new ParsingInterruptedException();
            }
        }
        if (node.is(AyaPsiElementTypes.LIT_STRING_EXPR)) {
            StringSlice text = node.tokenText();
            StringSlice content = text.substring(1, text.length() - 1);
            return new WithPos(pos, (Object)new Expr.LitString(StringUtil.escapeStringCharacters((String)content.toString())));
        }
        if (node.is(AyaPsiElementTypes.ULIFT_ATOM)) {
            WithPos expr = this.expr(node.child(EXPR));
            Integer lifts = (Integer)node.childrenOfType(AyaPsiElementTypes.ULIFT_PREFIX).collect(Collectors.summingInt(kw -> {
                StringSlice text = kw.tokenText();
                if ("ulift".contentEquals((CharSequence)text)) {
                    return 1;
                }
                return text.length();
            }));
            return lifts > 0 ? new WithPos(pos, (Object)new Expr.Lift(expr, lifts.intValue())) : expr;
        }
        if (node.is(AyaPsiElementTypes.TUPLE_ATOM)) {
            ImmutableSeq expr = node.child(AyaPsiElementTypes.COMMA_SEP).childrenOfType(EXPR).toImmutableSeq();
            if (expr.size() == 1) {
                return this.newBinOPScope(this.expr((GenericNode)expr.get(0)));
            }
            return new WithPos(pos, (Object)new Expr.Tuple(expr.map(this::expr)));
        }
        if (node.is(AyaPsiElementTypes.APP_EXPR)) {
            Expr.NamedArg head = new Expr.NamedArg(true, this.expr(node.child(EXPR)));
            MutableSinglyLinkedList tail = (MutableSinglyLinkedList)node.childrenOfType(ARGUMENT).map(this::argument).collect(MutableSinglyLinkedList.factory());
            tail.push((Object)head);
            return new WithPos(pos, (Object)new Expr.BinOpSeq(tail.toImmutableSeq()));
        }
        if (node.is(AyaPsiElementTypes.PROJ_EXPR)) {
            return new WithPos(pos, (Object)this.buildProj(this.expr(node.child(EXPR)), node.child(AyaPsiElementTypes.PROJ_FIX)));
        }
        if (node.is(AyaPsiElementTypes.ARROW_EXPR)) {
            ImmutableSeq exprs = node.childrenOfType(EXPR).toImmutableSeq();
            if (!exprs.sizeEquals(2)) {
                this.reporter.report((Problem)new ParseError(pos, exprs.joinToString((CharSequence)",", (CharSequence)("In an arrow expr, I see " + exprs.size() + " expr(s): ["), (CharSequence)"], but I need 2.", GenericNode::tokenText)));
                throw new ParsingInterruptedException();
            }
            GenericNode expr0 = (GenericNode)exprs.get(0);
            WithPos<Expr> to = this.expr((GenericNode)exprs.get(1));
            SourcePos paramPos = this.sourcePosOf(expr0);
            Expr.Param param = new Expr.Param(paramPos, Constants.randomlyNamed((SourcePos)paramPos), this.expr(expr0), true);
            return new WithPos(pos, (Object)new Expr.Pi(param, to));
        }
        if (node.is(AyaPsiElementTypes.PI_EXPR)) {
            return Expr.buildPi((SourcePos)pos, (SeqView)this.telescope(node.childrenOfType(AyaPsiElementTypes.TELE)).view(), this.expr(node.child(EXPR)));
        }
        if (node.is(AyaPsiElementTypes.FORALL_EXPR)) {
            return Expr.buildPi((SourcePos)pos, (SeqView)this.lambdaTelescope(node.childrenOfType(AyaPsiElementTypes.LAMBDA_TELE)).view(), this.expr(node.child(EXPR)));
        }
        if (node.is(AyaPsiElementTypes.SIGMA_EXPR)) {
            WithPos<Expr> last = this.expr(node.child(EXPR));
            return new WithPos(pos, (Object)new Expr.Sigma(this.telescope(node.childrenOfType(AyaPsiElementTypes.TELE)).appended((Object)new Expr.Param(last.sourcePos(), LocalVar.IGNORED, last, true))));
        }
        if (node.is(AyaPsiElementTypes.LAMBDA_EXPR)) {
            WithPos result;
            GenericNode bodyExpr = node.peekChild(EXPR);
            if (bodyExpr == null) {
                GenericNode impliesToken = node.peekChild(AyaPsiElementTypes.IMPLIES);
                SourcePos bodyHolePos = impliesToken == null ? pos : this.sourcePosOf(impliesToken);
                result = new WithPos(bodyHolePos, (Object)new Expr.Hole(false, null));
            } else {
                result = this.expr(bodyExpr);
            }
            SeqView tele = this.teleBinderUntyped(node.child(AyaPsiElementTypes.TELE_BINDER_UNTYPED)).view().map(LocalVar::from).map(v -> new Expr.Param(v.definition(), v, true));
            return Expr.buildLam((SourcePos)pos, (SeqView)tele, (WithPos)result);
        }
        if (node.is(AyaPsiElementTypes.IDIOM_ATOM)) {
            GenericNode block = node.peekChild(AyaPsiElementTypes.IDIOM_BLOCK);
            Expr.IdiomNames names = new Expr.IdiomNames(Constants.alternativeEmpty, Constants.alternativeOr, Constants.applicativeApp, Constants.functorPure);
            if (block == null) {
                return new WithPos(pos, (Object)new Expr.Idiom(names, ImmutableSeq.empty()));
            }
            return new WithPos(pos, (Object)new Expr.Idiom(names, block.childrenOfType(AyaPsiElementTypes.BARRED).flatMap(child -> child.childrenOfType(EXPR)).map(this::expr).appended(this.expr(block.child(EXPR))).toImmutableSeq()));
        }
        if (node.is(AyaPsiElementTypes.DO_EXPR)) {
            return new WithPos(pos, (Object)new Expr.Do(Constants.monadBind, node.child(AyaPsiElementTypes.COMMA_SEP).childrenOfType(AyaPsiElementTypes.DO_BLOCK_CONTENT).map(e -> {
                GenericNode bind = e.peekChild(AyaPsiElementTypes.DO_BINDING);
                if (bind != null) {
                    return this.doBinding(bind);
                }
                GenericNode expr = e.child(EXPR);
                return new Expr.DoBind(this.sourcePosOf(expr), LocalVar.IGNORED, this.expr(expr));
            }).toImmutableSeq()));
        }
        if (node.is(AyaPsiElementTypes.ARRAY_ATOM)) {
            GenericNode arrayBlock = node.peekChild(ARRAY_BLOCK);
            if (arrayBlock == null) {
                return new WithPos(pos, (Object)Expr.Array.newList((ImmutableSeq)ImmutableSeq.empty()));
            }
            if (arrayBlock.is(AyaPsiElementTypes.ARRAY_COMP_BLOCK)) {
                return new WithPos(pos, (Object)this.arrayCompBlock(arrayBlock));
            }
            if (arrayBlock.is(AyaPsiElementTypes.ARRAY_ELEMENTS_BLOCK)) {
                return new WithPos(pos, (Object)this.arrayElementList(arrayBlock));
            }
        }
        if (node.is(AyaPsiElementTypes.LET_EXPR)) {
            GenericNode bindBlockMaybe = node.peekChild(AyaPsiElementTypes.LET_BIND_BLOCK);
            WithPos<Expr> body = this.expr(node.child(EXPR));
            if (bindBlockMaybe != null) {
                SeqView binds = bindBlockMaybe.childrenOfType(AyaPsiElementTypes.LET_BIND).map(this::letBind);
                return Expr.buildLet((SourcePos)pos, (SeqView)binds, body);
            }
            QualifiedID component = this.qualifiedId(node.child(AyaPsiElementTypes.QUALIFIED_ID));
            GenericNode useHide = node.peekChild(AyaPsiElementTypes.USE_HIDE);
            return new WithPos(pos, (Object)new Expr.LetOpen(pos, component.component().resolve(component.name()), useHide == null ? UseHide.EMPTY : this.useHide(useHide), body));
        }
        return (WithPos)this.unreachable(node);
    }

    @NotNull
    public Expr.NamedArg argument(@NotNull GenericNode<?> node) {
        SourcePos pos = this.sourcePosOf(node);
        if (node.is(AyaPsiElementTypes.ATOM_EX_ARGUMENT)) {
            SeqView fixes = node.childrenOfType(AyaPsiElementTypes.PROJ_FIX);
            WithPos<Expr> expr = this.expr(node.child(EXPR));
            WithPos projected = (WithPos)fixes.foldLeft(expr, (acc, proj) -> new WithPos(acc.sourcePos(), (Object)this.buildProj((WithPos<Expr>)acc, (GenericNode<?>)proj)));
            return new Expr.NamedArg(true, null, projected);
        }
        if (node.is(AyaPsiElementTypes.TUPLE_IM_ARGUMENT)) {
            ImmutableSeq items = node.child(AyaPsiElementTypes.COMMA_SEP).childrenOfType(EXPR).map(this::expr).toImmutableSeq();
            if (items.sizeEquals(1)) {
                return new Expr.NamedArg(false, this.newBinOPScope((WithPos<Expr>)((WithPos)items.getFirst())));
            }
            WithPos tupExpr = new WithPos(pos, (Object)new Expr.Tuple(items));
            return new Expr.NamedArg(false, tupExpr);
        }
        if (node.is(AyaPsiElementTypes.NAMED_IM_ARGUMENT)) {
            WithPos<String> id = this.weakId(node.child(AyaPsiElementTypes.WEAK_ID));
            return new Expr.NamedArg(false, (String)id.data(), this.expr(node.child(EXPR)));
        }
        return (Expr.NamedArg)this.unreachable(node);
    }

    @NotNull
    private Expr buildProj(@NotNull WithPos<Expr> projectee, @NotNull GenericNode<?> fix) {
        GenericNode number = fix.peekChild(AyaPsiElementTypes.NUMBER);
        if (number != null) {
            return new Expr.Proj(projectee, (Either)Either.left((Object)number.tokenText().toInt()));
        }
        QualifiedID qid = this.qualifiedId(fix.child(AyaPsiElementTypes.PROJ_FIX_ID).child(AyaPsiElementTypes.QUALIFIED_ID));
        return new Expr.Proj(projectee, (Either)Either.right((Object)qid));
    }

    @NotNull
    public Arg<WithPos<Pattern>> pattern(@NotNull GenericNode<?> node) {
        GenericNode innerPattern = node.child(AyaPsiElementTypes.UNIT_PATTERNS);
        SourcePos entirePos = this.sourcePosOf(node);
        SourcePos innerPatternPos = this.sourcePosOf(innerPattern);
        ImmutableSeq<Arg<WithPos<Pattern>>> unitPats = this.unitPatterns(innerPattern);
        Option as = Option.ofNullable((Object)node.peekChild(AyaPsiElementTypes.WEAK_ID)).map(this::weakId).map(LocalVar::from);
        Arg pattern = unitPats.sizeEquals(1) ? (Arg)unitPats.getFirst() : new Arg((Object)new WithPos(innerPatternPos, (Object)new Pattern.BinOpSeq(unitPats)), true);
        return as.isDefined() ? Pattern.As.wrap((Arg)pattern, (LocalVar)((LocalVar)as.get())).map(x -> new WithPos(entirePos, x)) : pattern;
    }

    @NotNull
    private ImmutableSeq<Arg<WithPos<Pattern>>> unitPatterns(@NotNull GenericNode<?> node) {
        return node.childrenOfType(AyaPsiElementTypes.UNIT_PATTERN).map(this::unitPattern).toImmutableSeq();
    }

    private Arg<WithPos<Pattern>> unitPattern(@NotNull GenericNode<?> node) {
        GenericNode rawPatterns = node.peekChild(AyaPsiElementTypes.LICIT);
        if (rawPatterns != null) {
            return (Arg)this.licit(rawPatterns, AyaPsiElementTypes.PATTERNS, (explicit, child) -> {
                Pattern pat;
                ImmutableSeq<Arg<WithPos<Pattern>>> patterns = this.patterns(child = child.child(AyaPsiElementTypes.COMMA_SEP));
                if (patterns.sizeEquals(1)) {
                    pat = this.newBinOPScope((WithPos<Pattern>)((WithPos)((Arg)patterns.getFirst()).term()), explicit);
                } else {
                    ImmutableSeq implicitTupElem = patterns.filterNot(Arg::explicit);
                    implicitTupElem.forEach(p -> {
                        SourcePos pos = ((WithPos)p.term()).sourcePos();
                        this.reporter.report((Problem)new ParseError(pos, "Implicit pattern is not allowed here."));
                    });
                    pat = new Pattern.Tuple(patterns.map(Arg::term));
                }
                return new Arg((Object)new WithPos(this.sourcePosOf(node), (Object)pat), explicit);
            });
        }
        return new Arg(this.atomPattern((GenericNode)node.childrenView().getFirst()), true);
    }

    @NotNull
    private WithPos<Pattern> atomPattern(@NotNull GenericNode<?> node) {
        return new WithPos(this.sourcePosOf(node), (Object)this.doAtomPattern(node));
    }

    @NotNull
    private Pattern doAtomPattern(@NotNull GenericNode<?> node) {
        if (node.is(AyaPsiElementTypes.ATOM_BIND_PATTERN)) {
            QualifiedID qualifiedId = this.qualifiedId(node.child(AyaPsiElementTypes.QUALIFIED_ID));
            if (qualifiedId.isUnqualified()) {
                return new Pattern.Bind(LocalVar.from((WithPos)new WithPos(qualifiedId.sourcePos(), (Object)qualifiedId.name())));
            }
            return new Pattern.QualifiedRef(qualifiedId);
        }
        if (node.is(AyaPsiElementTypes.ATOM_LIST_PATTERN)) {
            GenericNode patternsNode = node.peekChild(AyaPsiElementTypes.PATTERNS);
            SeqView patterns = patternsNode != null ? this.patterns(patternsNode.child(AyaPsiElementTypes.COMMA_SEP)).view() : SeqView.empty();
            return new Pattern.List(patterns.map(pat -> {
                if (!pat.explicit()) {
                    this.reporter.report((Problem)new ParseError(((WithPos)pat.term()).sourcePos(), "Implicit elements in a list pattern is disallowed"));
                }
                return (WithPos)pat.term();
            }).toImmutableSeq());
        }
        if (node.peekChild(AyaPsiElementTypes.NUMBER) != null) {
            return new Pattern.Number(node.tokenText().toInt());
        }
        if (node.peekChild(AyaPsiElementTypes.LPAREN) != null) {
            return Pattern.Absurd.INSTANCE;
        }
        if (node.peekChild(AyaPsiElementTypes.CALM_FACE) != null) {
            return Pattern.CalmFace.INSTANCE;
        }
        return (Pattern)this.unreachable(node);
    }

    @NotNull
    private Expr.Array arrayCompBlock(@NotNull GenericNode<?> node) {
        WithPos<Expr> generator = this.expr(node.child(EXPR));
        ImmutableSeq bindings = node.child(AyaPsiElementTypes.COMMA_SEP).childrenOfType(AyaPsiElementTypes.DO_BINDING).map(this::doBinding).toImmutableSeq();
        Expr.Array.ListCompNames names = new Expr.Array.ListCompNames(Constants.monadBind, Constants.functorPure);
        return Expr.Array.newGenerator(generator, (ImmutableSeq)bindings, (Expr.Array.ListCompNames)names);
    }

    @NotNull
    private Expr.Array arrayElementList(@NotNull GenericNode<?> node) {
        ImmutableSeq exprs = node.child(AyaPsiElementTypes.COMMA_SEP).childrenOfType(EXPR).map(this::expr).toImmutableSeq();
        return Expr.Array.newList((ImmutableSeq)exprs);
    }

    @NotNull
    public Expr.LetBind letBind(@NotNull GenericNode<?> node) {
        SourcePos pos = this.sourcePosOf(node);
        WithPos<String> bind = this.weakId(node.child(AyaPsiElementTypes.WEAK_ID));
        ImmutableSeq<Expr.Param> teles = this.lambdaTelescope(node.childrenOfType(AyaPsiElementTypes.LAMBDA_TELE).map(x -> x));
        WithPos<Expr> result = this.typeOrHole(node.peekChild(AyaPsiElementTypes.TYPE), pos);
        WithPos<Expr> body = this.expr(node.child(EXPR));
        return new Expr.LetBind(bind.sourcePos(), LocalVar.from(bind), teles, result, body);
    }

    @NotNull
    public ImmutableSeq<Arg<WithPos<Pattern>>> patterns(@NotNull GenericNode<?> node) {
        return node.childrenOfType(AyaPsiElementTypes.PATTERN).map(this::pattern).toImmutableSeq();
    }

    @NotNull
    public Pattern.Clause clause(@NotNull GenericNode<?> node) {
        return new Pattern.Clause(this.sourcePosOf(node), this.patterns(node.child(AyaPsiElementTypes.PATTERNS).child(AyaPsiElementTypes.COMMA_SEP)), Option.ofNullable((Object)node.peekChild(EXPR)).map(this::expr));
    }

    @NotNull
    public Pattern.Clause bareOrBarredClause(@NotNull GenericNode<?> node) {
        return this.clause(node.child(AyaPsiElementTypes.CLAUSE));
    }

    @NotNull
    public WithPos<Expr> type(@NotNull GenericNode<?> node) {
        return this.expr(node.child(EXPR));
    }

    @Nullable
    public WithPos<Expr> typeOrNull(@Nullable GenericNode<?> node) {
        if (node == null) {
            return null;
        }
        GenericNode child = node.peekChild(EXPR);
        if (child == null) {
            this.reporter.report((Problem)new ParseError(this.sourcePosOf(node), "Expect the return type expression"));
            return null;
        }
        return this.expr(child);
    }

    @NotNull
    public WithPos<Expr> typeOrHole(@Nullable GenericNode<?> node, @NotNull SourcePos pos) {
        return node == null ? new WithPos(pos, (Object)new Expr.Hole(false, null)) : this.type(node);
    }

    @NotNull
    public WithPos<String> weakId(@NotNull GenericNode<?> node) {
        return new WithPos(this.sourcePosOf(node), (Object)node.tokenText().toString());
    }

    @NotNull
    public WithPos<String> generalizeParamName(@NotNull GenericNode<?> node) {
        return this.teleParamName(node.child(AyaPsiElementTypes.TELE_PARAM_NAME));
    }

    @NotNull
    public WithPos<String> teleParamName(@NotNull GenericNode<?> node) {
        return this.weakId(node.child(AyaPsiElementTypes.WEAK_ID));
    }

    @NotNull
    public WithPos<String> newArgField(@NotNull GenericNode<?> node) {
        return this.weakId(node.child(AyaPsiElementTypes.WEAK_ID));
    }

    @NotNull
    public QualifiedID qualifiedId(@NotNull GenericNode<?> node) {
        return new QualifiedID(this.sourcePosOf(node), node.childrenOfType(AyaPsiElementTypes.WEAK_ID).map(this::weakId).map(WithPos::data).toImmutableSeq());
    }

    @NotNull
    public ModulePath modulePath(@NotNull GenericNode<?> node) {
        return new ModulePath(node.childrenOfType(AyaPsiElementTypes.WEAK_ID).map(this::weakId).map(WithPos::data).toImmutableSeq());
    }

    @NotNull
    public Expr.DoBind doBinding(@NotNull GenericNode<?> node) {
        WithPos<String> wp = this.weakId(node.child(AyaPsiElementTypes.WEAK_ID));
        return new Expr.DoBind(wp.sourcePos(), LocalVar.from(wp), this.expr(node.child(EXPR)));
    }

    private <T> T unreachable(GenericNode<?> node) {
        throw new Panic(String.valueOf(node.elementType()) + ": " + String.valueOf(node.tokenText()));
    }

    @NotNull
    public WithPos<Expr> newBinOPScope(@NotNull WithPos<Expr> expr) {
        return new WithPos(expr.sourcePos(), (Object)new Expr.BinOpSeq(ImmutableSeq.of((Object)new Expr.NamedArg(true, expr))));
    }

    @NotNull
    public Pattern newBinOPScope(@NotNull WithPos<Pattern> expr, boolean explicit) {
        return new Pattern.BinOpSeq(ImmutableSeq.of((Object)new Arg(expr, explicit)));
    }

    @NotNull
    private SourcePos sourcePosOf(@NotNull GenericNode<?> node) {
        return (SourcePos)this.source.fold(file -> AyaProducer.sourcePosOf(node, file), pos -> pos);
    }

    @NotNull
    public static SourcePos sourcePosOf(@NotNull GenericNode<?> node, @NotNull SourceFile file) {
        return AyaProducer.sourcePosOf(node.range(), file, AyaProducer.isTerminalNode(node));
    }

    public static boolean isTerminalNode(@NotNull GenericNode<?> node) {
        return node.elementType() instanceof AyaPsiTokenType;
    }

    @NotNull
    public static SourcePos sourcePosOf(@NotNull FlexLexer.Token token, @NotNull SourceFile file) {
        return AyaProducer.sourcePosOf(token.range(), file, true);
    }

    @NotNull
    public static SourcePos sourcePosOf(@NotNull TextRange range, @NotNull SourceFile file, boolean isTerminal) {
        LineColumn start = StringUtil.offsetToLineColumn((CharSequence)file.sourceCode(), (int)range.getStartOffset());
        int length = range.getLength();
        int endOffset = range.getEndOffset() - (length == 0 ? 0 : 1);
        LineColumn end = isTerminal || length == 0 ? LineColumn.of((int)start.line, (int)(start.column + length - 1)) : StringUtil.offsetToLineColumn((CharSequence)file.sourceCode(), (int)endOffset);
        return new SourcePos(file, range.getStartOffset(), endOffset, start.line + 1, start.column, end.line + 1, end.column);
    }

    private record DeclNameOrInfix(@NotNull WithPos<String> name, @Nullable OpDecl.OpInfo infix) {
    }

    private record DeclParseData(@NotNull GenericNode<?> node, @NotNull DeclInfo info, @Nullable String name, @NotNull ModifierParser.Modifiers modifier) {
        @Nullable
        public String checkName(@NotNull AyaProducer self) {
            if (this.name != null) {
                return this.name;
            }
            return (String)self.error((GenericNode)this.node.childrenView().getFirst(), "Expect a name");
        }
    }

    @FunctionalInterface
    private static interface LicitParser<T>
    extends BooleanObjBiFunction<GenericNode<?>, T> {
    }
}

