/*
 * Decompiled with CFR 0.152.
 */
package org.aya.producer;

import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.DefaultPsiParser;
import java.nio.file.Path;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import org.aya.intellij.GenericNode;
import org.aya.intellij.MarkerNodeWrapper;
import org.aya.parser.AyaLanguage;
import org.aya.parser.AyaParserDefinitionBase;
import org.aya.parser.AyaPsiElementTypes;
import org.aya.producer.AyaProducer;
import org.aya.producer.ParserUtil;
import org.aya.syntax.GenericAyaParser;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;

public record AyaParserImpl(@NotNull Reporter reporter) implements GenericAyaParser
{
    @NotNull
    public GenericNode<?> parseNode(@NotNull String code) {
        AyaFleetParser parser = new AyaFleetParser();
        return new MarkerNodeWrapper(code, parser.parse(code));
    }

    @NotNull
    public WithPos<Expr> expr(@NotNull String code, @NotNull SourcePos sourcePos) {
        GenericNode<?> node = this.parseNode("prim a : " + code);
        GenericNode type = node.child(AyaPsiElementTypes.PRIM_DECL).child(AyaPsiElementTypes.TYPE);
        return new AyaProducer((Either<SourceFile, SourcePos>)Either.right((Object)sourcePos), this.reporter).type(type);
    }

    @NotNull
    public ImmutableSeq<Stmt> program(@NotNull SourceFile sourceFile, @NotNull SourceFile errorReport) {
        Either<ImmutableSeq<Stmt>, WithPos<Expr>> parse = this.parse(sourceFile.sourceCode(), errorReport);
        if (parse.isRight()) {
            this.reporter.reportString("Expect statement, got repl expression", Problem.Severity.ERROR);
            return ImmutableSeq.empty();
        }
        return (ImmutableSeq)parse.getLeftValue();
    }

    @NotNull
    private Either<ImmutableSeq<Stmt>, WithPos<Expr>> parse(@NotNull String code, @NotNull SourceFile errorReport) {
        GenericNode<?> node = ParserUtil.reportErrorElements(this.parseNode(code), errorReport, this.reporter);
        return new AyaProducer((Either<SourceFile, SourcePos>)Either.left((Object)errorReport), this.reporter).program(node);
    }

    @NotNull
    public Either<ImmutableSeq<Stmt>, WithPos<Expr>> repl(@NotNull String code) {
        return this.parse(code, AyaParserImpl.replSourceFile(code));
    }

    @NotNull
    private static SourceFile replSourceFile(@NotNull String text) {
        return new SourceFile("<stdin>", Path.of("stdin", new String[0]), text);
    }

    private static class AyaFleetParser
    extends DefaultPsiParser {
        public AyaFleetParser() {
            super((ParserDefinition)new AyaParserDefinitionBase(ParserUtil.forLanguage((Language)AyaLanguage.INSTANCE)));
        }
    }
}

