/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.visualizer;

import java.nio.charset.StandardCharsets;
import org.aya.cube.compiler.CompiledPoint;
import org.ice1000.jimgui.NativeString;
import org.jetbrains.annotations.NotNull;

public record PointData(@NotNull NativeString latex) implements AutoCloseable
{
    public static final byte[] BULLET = "\\bullet".getBytes(StandardCharsets.US_ASCII);

    public PointData() {
        this(new NativeString());
        for (byte b : BULLET) {
            this.latex.append(b);
        }
    }

    @Override
    public void close() {
        this.latex.close();
    }

    @NotNull
    public CompiledPoint serialize() {
        return new CompiledPoint(this.latex.toBytes());
    }

    public void deserialize(@NotNull CompiledPoint serialized) {
        this.latex.clear();
        for (byte b : serialized.latex()) {
            this.latex.append(b);
        }
    }
}

